package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.SettingsUtil;
import baritone.api.utils.interfaces.IGoalRenderPos;
import iw;

public class GoalGetToBlock implements Goal, IGoalRenderPos {
  public final int x;
  
  public final int y;
  
  public final int z;
  
  public GoalGetToBlock(iw paramiw) {
    this.x = paramiw.u();
    this.y = paramiw.v();
    this.z = paramiw.w();
  }
  
  public iw getGoalPos() {
    return new iw(this.x, this.y, this.z);
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 -= this.x;
    paramInt2 -= this.y;
    paramInt3 -= this.z;
    return (Math.abs(paramInt1) + Math.abs((paramInt2 < 0) ? (paramInt2 + 1) : paramInt2) + Math.abs(paramInt3) <= 1);
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 -= this.x;
    paramInt2 -= this.y;
    paramInt3 -= this.z;
    return GoalBlock.calculate(paramInt1, (paramInt2 < 0) ? (paramInt2 + 1) : paramInt2, paramInt3);
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return (this.x == ((baritone.api.pathing.goals.GoalGetToBlock)paramObject).x && this.y == ((baritone.api.pathing.goals.GoalGetToBlock)paramObject).y && this.z == ((baritone.api.pathing.goals.GoalGetToBlock)paramObject).z);
  }
  
  public int hashCode() {
    return (int)BetterBlockPos.longHash(this.x, this.y, this.z) * -49639096;
  }
  
  public String toString() {
    return String.format("GoalGetToBlock{x=%s,y=%s,z=%s}", new Object[] { SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z) });
  }
}
