package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import java.util.Arrays;

public class GoalComposite implements Goal {
  private final Goal[] goals;
  
  public GoalComposite(Goal... paramVarArgs) {
    this.goals = paramVarArgs;
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    Goal[] arrayOfGoal;
    int i = (arrayOfGoal = this.goals).length;
    for (byte b = 0; b < i; b++) {
      if (arrayOfGoal[b].isInGoal(paramInt1, paramInt2, paramInt3))
        return true; 
    } 
    return false;
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    double d = Double.MAX_VALUE;
    Goal[] arrayOfGoal;
    int i = (arrayOfGoal = this.goals).length;
    for (byte b = 0; b < i; b++) {
      Goal goal = arrayOfGoal[b];
      d = Math.min(d, goal.heuristic(paramInt1, paramInt2, paramInt3));
    } 
    return d;
  }
  
  public double heuristic() {
    double d = Double.MAX_VALUE;
    Goal[] arrayOfGoal;
    int i = (arrayOfGoal = this.goals).length;
    for (byte b = 0; b < i; b++) {
      Goal goal = arrayOfGoal[b];
      d = Math.min(d, goal.heuristic());
    } 
    return d;
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return Arrays.equals((Object[])this.goals, (Object[])((baritone.api.pathing.goals.GoalComposite)paramObject).goals);
  }
  
  public int hashCode() {
    return Arrays.hashCode((Object[])this.goals);
  }
  
  public String toString() {
    return "GoalComposite" + Arrays.toString((Object[])this.goals);
  }
  
  public Goal[] goals() {
    return this.goals;
  }
}
