package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.pathing.goals.GoalYLevel;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.SettingsUtil;
import baritone.api.utils.interfaces.IGoalRenderPos;
import iw;

public class GoalBlock implements Goal, IGoalRenderPos {
  public final int x;
  
  public final int y;
  
  public final int z;
  
  public GoalBlock(iw paramiw) {
    this(paramiw.u(), paramiw.v(), paramiw.w());
  }
  
  public GoalBlock(int paramInt1, int paramInt2, int paramInt3) {
    this.x = paramInt1;
    this.y = paramInt2;
    this.z = paramInt3;
  }
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    return (paramInt1 == this.x && paramInt2 == this.y && paramInt3 == this.z);
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 -= this.x;
    paramInt2 -= this.y;
    paramInt3 -= this.z;
    return calculate(paramInt1, paramInt2, paramInt3);
  }
  
  public boolean equals(Object paramObject) {
    if (this == paramObject)
      return true; 
    if (paramObject == null || getClass() != paramObject.getClass())
      return false; 
    paramObject = paramObject;
    return (this.x == ((baritone.api.pathing.goals.GoalBlock)paramObject).x && this.y == ((baritone.api.pathing.goals.GoalBlock)paramObject).y && this.z == ((baritone.api.pathing.goals.GoalBlock)paramObject).z);
  }
  
  public int hashCode() {
    return (int)BetterBlockPos.longHash(this.x, this.y, this.z) * 905165533;
  }
  
  public String toString() {
    return String.format("GoalBlock{x=%s,y=%s,z=%s}", new Object[] { SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z) });
  }
  
  public iw getGoalPos() {
    return new iw(this.x, this.y, this.z);
  }
  
  public static double calculate(double paramDouble1, int paramInt, double paramDouble2) {
    return 0.0D + GoalYLevel.calculate(0, paramInt) + GoalXZ.calculate(paramDouble1, paramDouble2);
  }
}
