package baritone.api.pathing.goals;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalYLevel;

public class GoalAxis implements Goal {
  private static final double SQRT_2_OVER_2 = Math.sqrt(2.0D) / 2.0D;
  
  public boolean isInGoal(int paramInt1, int paramInt2, int paramInt3) {
    return (paramInt2 == ((Integer)(BaritoneAPI.getSettings()).axisHeight.value).intValue() && (paramInt1 == 0 || paramInt3 == 0 || Math.abs(paramInt1) == Math.abs(paramInt3)));
  }
  
  public double heuristic(int paramInt1, int paramInt2, int paramInt3) {
    paramInt1 = Math.abs(paramInt1);
    paramInt3 = Math.abs(paramInt3);
    int i = Math.min(paramInt1, paramInt3);
    i = Math.max(paramInt1, paramInt3) - i;
    return Math.min(paramInt1, Math.min(paramInt3, i * SQRT_2_OVER_2)) * ((Double)(BaritoneAPI.getSettings()).costHeuristic.value).doubleValue() + GoalYLevel.calculate(((Integer)(BaritoneAPI.getSettings()).axisHeight.value).intValue(), paramInt2);
  }
  
  public boolean equals(Object paramObject) {
    return (paramObject.getClass() == baritone.api.pathing.goals.GoalAxis.class);
  }
  
  public int hashCode() {
    return 201385781;
  }
  
  public String toString() {
    return "GoalAxis";
  }
}
