package baritone.api.pathing.calc;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.movement.IMovement;
import baritone.api.utils.BetterBlockPos;
import java.util.HashSet;
import java.util.List;

public interface IPath {
  List<IMovement> movements();
  
  List<BetterBlockPos> positions();
  
  default baritone.api.pathing.calc.IPath postProcess() {
    throw new UnsupportedOperationException();
  }
  
  default int length() {
    return positions().size();
  }
  
  Goal getGoal();
  
  int getNumNodesConsidered();
  
  default BetterBlockPos getSrc() {
    return positions().get(0);
  }
  
  default BetterBlockPos getDest() {
    return positions().get(positions().size() - 1);
  }
  
  default double ticksRemainingFrom(int paramInt) {
    double d = 0.0D;
    List<IMovement> list = movements();
    while (paramInt < list.size()) {
      d += ((IMovement)list.get(paramInt)).getCost();
      paramInt++;
    } 
    return d;
  }
  
  default baritone.api.pathing.calc.IPath cutoffAtLoadedChunks(Object paramObject) {
    throw new UnsupportedOperationException();
  }
  
  default baritone.api.pathing.calc.IPath staticCutoff(Goal paramGoal) {
    throw new UnsupportedOperationException();
  }
  
  default void sanityCheck() {
    List<BetterBlockPos> list = positions();
    List<IMovement> list1 = movements();
    if (!getSrc().equals(list.get(0)))
      throw new IllegalStateException("Start node does not equal first path element"); 
    if (!getDest().equals(list.get(list.size() - 1)))
      throw new IllegalStateException("End node does not equal last path element"); 
    if (list.size() != list1.size() + 1)
      throw new IllegalStateException("Size of path array is unexpected"); 
    HashSet<BetterBlockPos> hashSet = new HashSet();
    for (byte b = 0; b < list.size() - 1; b++) {
      BetterBlockPos betterBlockPos1 = list.get(b);
      BetterBlockPos betterBlockPos2 = list.get(b + 1);
      IMovement iMovement = list1.get(b);
      if (!betterBlockPos1.equals(iMovement.getSrc()))
        throw new IllegalStateException("Path source is not equal to the movement source"); 
      if (!betterBlockPos2.equals(iMovement.getDest()))
        throw new IllegalStateException("Path destination is not equal to the movement destination"); 
      if (hashSet.contains(betterBlockPos1))
        throw new IllegalStateException("Path doubles back on itself, making a loop"); 
      hashSet.add(betterBlockPos1);
    } 
  }
}
