package baritone.api.event.listener;

package .tmp;

import baritone.api.event.events.BlockChangeEvent;
import baritone.api.event.events.BlockInteractEvent;
import baritone.api.event.events.ChatEvent;
import baritone.api.event.events.ChunkEvent;
import baritone.api.event.events.PacketEvent;
import baritone.api.event.events.PathEvent;
import baritone.api.event.events.PlayerUpdateEvent;
import baritone.api.event.events.RenderEvent;
import baritone.api.event.events.RotationMoveEvent;
import baritone.api.event.events.SprintStateEvent;
import baritone.api.event.events.TabCompleteEvent;
import baritone.api.event.events.TickEvent;
import baritone.api.event.events.WorldEvent;

public interface IGameEventListener {
  void onTick(TickEvent paramTickEvent);
  
  void onPostTick(TickEvent paramTickEvent);
  
  void onPlayerUpdate(PlayerUpdateEvent paramPlayerUpdateEvent);
  
  void onSendChatMessage(ChatEvent paramChatEvent);
  
  void onPreTabComplete(TabCompleteEvent paramTabCompleteEvent);
  
  void onChunkEvent(ChunkEvent paramChunkEvent);
  
  void onBlockChange(BlockChangeEvent paramBlockChangeEvent);
  
  void onRenderPass(RenderEvent paramRenderEvent);
  
  void onWorldEvent(WorldEvent paramWorldEvent);
  
  void onSendPacket(PacketEvent paramPacketEvent);
  
  void onReceivePacket(PacketEvent paramPacketEvent);
  
  void onPlayerRotationMove(RotationMoveEvent paramRotationMoveEvent);
  
  void onPlayerSprintState(SprintStateEvent paramSprintStateEvent);
  
  void onBlockInteract(BlockInteractEvent paramBlockInteractEvent);
  
  void onPlayerDeath();
  
  void onPathEvent(PathEvent paramPathEvent);
}
