package baritone.api.event.listener;

package .tmp;

import baritone.api.event.events.BlockChangeEvent;
import baritone.api.event.events.BlockInteractEvent;
import baritone.api.event.events.ChatEvent;
import baritone.api.event.events.ChunkEvent;
import baritone.api.event.events.PacketEvent;
import baritone.api.event.events.PathEvent;
import baritone.api.event.events.PlayerUpdateEvent;
import baritone.api.event.events.RenderEvent;
import baritone.api.event.events.RotationMoveEvent;
import baritone.api.event.events.SprintStateEvent;
import baritone.api.event.events.TabCompleteEvent;
import baritone.api.event.events.TickEvent;
import baritone.api.event.events.WorldEvent;
import baritone.api.event.listener.IGameEventListener;

public interface AbstractGameEventListener extends IGameEventListener {
  default void onTick(TickEvent paramTickEvent) {}
  
  default void onPostTick(TickEvent paramTickEvent) {}
  
  default void onPlayerUpdate(PlayerUpdateEvent paramPlayerUpdateEvent) {}
  
  default void onSendChatMessage(ChatEvent paramChatEvent) {}
  
  default void onPreTabComplete(TabCompleteEvent paramTabCompleteEvent) {}
  
  default void onChunkEvent(ChunkEvent paramChunkEvent) {}
  
  default void onBlockChange(BlockChangeEvent paramBlockChangeEvent) {}
  
  default void onRenderPass(RenderEvent paramRenderEvent) {}
  
  default void onWorldEvent(WorldEvent paramWorldEvent) {}
  
  default void onSendPacket(PacketEvent paramPacketEvent) {}
  
  default void onReceivePacket(PacketEvent paramPacketEvent) {}
  
  default void onPlayerRotationMove(RotationMoveEvent paramRotationMoveEvent) {}
  
  default void onPlayerSprintState(SprintStateEvent paramSprintStateEvent) {}
  
  default void onBlockInteract(BlockInteractEvent paramBlockInteractEvent) {}
  
  default void onPlayerDeath() {}
  
  default void onPathEvent(PathEvent paramPathEvent) {}
}
