package baritone.api.command.registry;

package .tmp;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Registry<V> {
  private final Deque<V> _entries = new LinkedList<>();
  
  private final Set<V> registered = new HashSet<>();
  
  public final Collection<V> entries = Collections.unmodifiableCollection(this._entries);
  
  public boolean registered(V paramV) {
    return this.registered.contains(paramV);
  }
  
  public boolean register(V paramV) {
    if (!registered(paramV)) {
      this._entries.addFirst(paramV);
      this.registered.add(paramV);
      return true;
    } 
    return false;
  }
  
  public void unregister(V paramV) {
    if (!registered(paramV))
      return; 
    this._entries.remove(paramV);
    this.registered.remove(paramV);
  }
  
  public Iterator<V> iterator() {
    return this._entries.iterator();
  }
  
  public Iterator<V> descendingIterator() {
    return this._entries.descendingIterator();
  }
  
  public Stream<V> stream() {
    return this._entries.stream();
  }
  
  public Stream<V> descendingStream() {
    return StreamSupport.stream(Spliterators.spliterator(descendingIterator(), this._entries.size(), 16448), false);
  }
}
