package baritone.api.command.helpers;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import alr;
import baritone.api.BaritoneAPI;
import baritone.api.Settings;
import baritone.api.command.ICommand;
import baritone.api.command.manager.ICommandManager;
import baritone.api.utils.SettingsUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class TabCompleteHelper {
  private Stream<String> stream;
  
  public TabCompleteHelper(String[] paramArrayOfString) {
    this.stream = Stream.of(paramArrayOfString);
  }
  
  public TabCompleteHelper(List<String> paramList) {
    this.stream = paramList.stream();
  }
  
  public TabCompleteHelper() {
    this.stream = Stream.empty();
  }
  
  public baritone.api.command.helpers.TabCompleteHelper append(Stream<String> paramStream) {
    this.stream = Stream.concat(this.stream, paramStream);
    return this;
  }
  
  public baritone.api.command.helpers.TabCompleteHelper append(String... paramVarArgs) {
    return append(Stream.of(paramVarArgs));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper append(Class<? extends Enum<?>> paramClass) {
    return append(Stream.<Enum>of((Enum[])paramClass.getEnumConstants()).map(Enum::name).map(String::toLowerCase));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper prepend(Stream<String> paramStream) {
    this.stream = Stream.concat(paramStream, this.stream);
    return this;
  }
  
  public baritone.api.command.helpers.TabCompleteHelper prepend(String... paramVarArgs) {
    return prepend(Stream.of(paramVarArgs));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper prepend(Class<? extends Enum<?>> paramClass) {
    return prepend(Stream.<Enum>of((Enum[])paramClass.getEnumConstants()).map(Enum::name).map(String::toLowerCase));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper map(Function<String, String> paramFunction) {
    this.stream = this.stream.map(paramFunction);
    return this;
  }
  
  public baritone.api.command.helpers.TabCompleteHelper filter(Predicate<String> paramPredicate) {
    this.stream = this.stream.filter(paramPredicate);
    return this;
  }
  
  public baritone.api.command.helpers.TabCompleteHelper sort(Comparator<String> paramComparator) {
    this.stream = this.stream.sorted(paramComparator);
    return this;
  }
  
  public baritone.api.command.helpers.TabCompleteHelper sortAlphabetically() {
    return sort(String.CASE_INSENSITIVE_ORDER);
  }
  
  public baritone.api.command.helpers.TabCompleteHelper filterPrefix(String paramString) {
    return filter(paramString2 -> paramString2.toLowerCase(Locale.US).startsWith(paramString1.toLowerCase(Locale.US)));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper filterPrefixNamespaced(String paramString) {
    alr alr;
    if ((alr = alr.c(paramString)) == null) {
      this.stream = Stream.empty();
      return this;
    } 
    return filterPrefix(alr.toString());
  }
  
  public String[] build() {
    return this.stream.<String>toArray(paramInt -> new String[paramInt]);
  }
  
  public Stream<String> stream() {
    return this.stream;
  }
  
  public baritone.api.command.helpers.TabCompleteHelper addCommands(ICommandManager paramICommandManager) {
    return append(paramICommandManager.getRegistry().descendingStream().flatMap(paramICommand -> paramICommand.getNames().stream()).distinct());
  }
  
  public baritone.api.command.helpers.TabCompleteHelper addSettings() {
    return append((BaritoneAPI.getSettings()).allSettings.stream().filter(paramSetting -> !paramSetting.isJavaOnly()).map(Settings.Setting::getName).sorted(String.CASE_INSENSITIVE_ORDER));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper addModifiedSettings() {
    return append(SettingsUtil.modifiedSettings(BaritoneAPI.getSettings()).stream().map(Settings.Setting::getName).sorted(String.CASE_INSENSITIVE_ORDER));
  }
  
  public baritone.api.command.helpers.TabCompleteHelper addToggleableSettings() {
    return append(BaritoneAPI.getSettings().getAllValuesByType(Boolean.class).stream().map(Settings.Setting::getName).sorted(String.CASE_INSENSITIVE_ORDER));
  }
}
