package baritone.api.command.helpers;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.utils.Helper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import o;
import xe;
import xg;
import xm;
import xu;

public class Paginator<E> implements Helper {
  public final List<E> entries;
  
  public int pageSize = 8;
  
  public int page = 1;
  
  public Paginator(List<E> paramList) {
    this.entries = paramList;
  }
  
  public Paginator(E... paramVarArgs) {
    this.entries = Arrays.asList(paramVarArgs);
  }
  
  public baritone.api.command.helpers.Paginator<E> setPageSize(int paramInt) {
    this.pageSize = paramInt;
    return this;
  }
  
  public int getMaxPage() {
    return (this.entries.size() - 1) / this.pageSize + 1;
  }
  
  public boolean validPage(int paramInt) {
    return (paramInt > 0 && paramInt <= getMaxPage());
  }
  
  public baritone.api.command.helpers.Paginator<E> skipPages(int paramInt) {
    this.page += paramInt;
    return this;
  }
  
  public void display(Function<E, xg> paramFunction, String paramString) {
    int j;
    for (int i = (this.page - 1) * this.pageSize; j < i + this.pageSize; j++) {
      if (j < this.entries.size()) {
        logDirect(new xg[] { paramFunction.apply(this.entries.get(j)) });
      } else {
        logDirect("--", o.i);
      } 
    } 
    j = (paramString != null && validPage(this.page - 1)) ? 1 : 0;
    boolean bool = (paramString != null && validPage(this.page + 1)) ? true : false;
    xu xu2 = xg.b("<<");
    if (j != 0) {
      xu2.b(xu2.a().a((xe)new xe.f(String.format("%s %d", new Object[] { paramString, Integer.valueOf(this.page - 1) }))).a((xm)new xm.e((xg)xg.b("Click to view previous page"))));
    } else {
      xu2.b(xu2.a().a(o.i));
    } 
    xu xu3 = xg.b(">>");
    if (bool) {
      xu3.b(xu3.a().a((xe)new xe.f(String.format("%s %d", new Object[] { paramString, Integer.valueOf(this.page + 1) }))).a((xm)new xm.e((xg)xg.b("Click to view next page"))));
    } else {
      xu3.b(xu3.a().a(o.i));
    } 
    xu xu1;
    xg.b("").b((xu1 = xg.b("")).a().a(o.h));
    xu1.b((xg)xu2);
    xu1.f(" | ");
    xu1.b((xg)xu3);
    xu1.f(String.format(" %d/%d", new Object[] { Integer.valueOf(this.page), Integer.valueOf(getMaxPage()) }));
    logDirect(new xg[] { (xg)xu1 });
  }
  
  public void display(Function<E, xg> paramFunction) {
    display(paramFunction, null);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, baritone.api.command.helpers.Paginator<T> paramPaginator, Runnable paramRunnable, Function<T, xg> paramFunction, String paramString) {
    int i = 1;
    paramIArgConsumer.requireMax(1);
    if (paramIArgConsumer.hasAny()) {
      i = ((Integer)paramIArgConsumer.getAs(Integer.class)).intValue();
      if (!paramPaginator.validPage(i))
        throw new CommandInvalidTypeException(paramIArgConsumer.consumed(), String.format("a valid page (1-%d)", new Object[] { Integer.valueOf(paramPaginator.getMaxPage()) }), paramIArgConsumer.consumed().getValue()); 
    } 
    paramPaginator.skipPages(i - paramPaginator.page);
    if (paramRunnable != null)
      paramRunnable.run(); 
    paramPaginator.display(paramFunction, paramString);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, List<T> paramList, Runnable paramRunnable, Function<T, xg> paramFunction, String paramString) {
    paginate(paramIArgConsumer, new baritone.api.command.helpers.Paginator<>(paramList), paramRunnable, paramFunction, paramString);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, T[] paramArrayOfT, Runnable paramRunnable, Function<T, xg> paramFunction, String paramString) {
    paginate(paramIArgConsumer, Arrays.asList(paramArrayOfT), paramRunnable, paramFunction, paramString);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, baritone.api.command.helpers.Paginator<T> paramPaginator, Function<T, xg> paramFunction, String paramString) {
    paginate(paramIArgConsumer, paramPaginator, null, paramFunction, paramString);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, List<T> paramList, Function<T, xg> paramFunction, String paramString) {
    paginate(paramIArgConsumer, new baritone.api.command.helpers.Paginator<>(paramList), null, paramFunction, paramString);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, T[] paramArrayOfT, Function<T, xg> paramFunction, String paramString) {
    paginate(paramIArgConsumer, Arrays.asList(paramArrayOfT), null, paramFunction, paramString);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, baritone.api.command.helpers.Paginator<T> paramPaginator, Runnable paramRunnable, Function<T, xg> paramFunction) {
    paginate(paramIArgConsumer, paramPaginator, paramRunnable, paramFunction, null);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, List<T> paramList, Runnable paramRunnable, Function<T, xg> paramFunction) {
    paginate(paramIArgConsumer, new baritone.api.command.helpers.Paginator<>(paramList), paramRunnable, paramFunction, null);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, T[] paramArrayOfT, Runnable paramRunnable, Function<T, xg> paramFunction) {
    paginate(paramIArgConsumer, Arrays.asList(paramArrayOfT), paramRunnable, paramFunction, null);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, baritone.api.command.helpers.Paginator<T> paramPaginator, Function<T, xg> paramFunction) {
    paginate(paramIArgConsumer, paramPaginator, null, paramFunction, null);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, List<T> paramList, Function<T, xg> paramFunction) {
    paginate(paramIArgConsumer, new baritone.api.command.helpers.Paginator<>(paramList), null, paramFunction, null);
  }
  
  public static <T> void paginate(IArgConsumer paramIArgConsumer, T[] paramArrayOfT, Function<T, xg> paramFunction) {
    paginate(paramIArgConsumer, Arrays.asList(paramArrayOfT), null, paramFunction, null);
  }
}
