package baritone.api.command.exception;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.command.argument.ICommandArgument;
import baritone.api.command.exception.CommandErrorMessageException;

public abstract class CommandInvalidArgumentException extends CommandErrorMessageException {
  public final ICommandArgument arg;
  
  protected CommandInvalidArgumentException(ICommandArgument paramICommandArgument, String paramString) {
    super(formatMessage(paramICommandArgument, paramString));
    this.arg = paramICommandArgument;
  }
  
  protected CommandInvalidArgumentException(ICommandArgument paramICommandArgument, String paramString, Throwable paramThrowable) {
    super(formatMessage(paramICommandArgument, paramString), paramThrowable);
    this.arg = paramICommandArgument;
  }
  
  private static String formatMessage(ICommandArgument paramICommandArgument, String paramString) {
    return String.format("Error at argument #%s: %s", new Object[] { (paramICommandArgument.getIndex() == -1) ? "<unknown>" : Integer.toString(paramICommandArgument.getIndex() + 1), paramString });
  }
}
