package baritone.api.command.datatypes;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.utils.Helper;
import fqq;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

public enum RelativeFile implements IDatatypePost<File, File> {
  INSTANCE;
  
  public final File apply(IDatatypeContext paramIDatatypeContext, File paramFile) {
    Path path;
    if (paramFile == null)
      paramFile = new File("./"); 
    try {
      path = FileSystems.getDefault().getPath(paramIDatatypeContext.getConsumer().getString(), new String[0]);
    } catch (InvalidPathException invalidPathException) {
      throw new IllegalArgumentException("invalid path");
    } 
    return getCanonicalFileUnchecked(paramFile.toPath().resolve(path).toFile());
  }
  
  public final Stream<String> tabComplete(IDatatypeContext paramIDatatypeContext) {
    return Stream.empty();
  }
  
  private static File getCanonicalFileUnchecked(File paramFile) {
    try {
      return paramFile.getCanonicalFile();
    } catch (IOException iOException) {
      throw new UncheckedIOException(iOException);
    } 
  }
  
  public static Stream<String> tabComplete(IArgConsumer paramIArgConsumer, File paramFile) {
    paramFile = getCanonicalFileUnchecked(paramFile);
    String str = paramIArgConsumer.getString();
    Path path1;
    Path path2 = (path1 = FileSystems.getDefault().getPath(str, new String[0])).isAbsolute() ? path1.getRoot() : paramFile.toPath();
    boolean bool = (!str.isEmpty() && !str.endsWith(File.separator)) ? true : false;
    paramFile = path1.isAbsolute() ? path1.toFile() : new File(paramFile, str);
    return Stream.<File>of(Objects.<File[]>requireNonNull(getCanonicalFileUnchecked(bool ? paramFile.getParentFile() : paramFile).listFiles())).map(paramFile -> String.valueOf(paramPath1.isAbsolute() ? paramFile : paramPath2.relativize(paramFile.toPath()).toString()) + String.valueOf(paramPath1.isAbsolute() ? paramFile : paramPath2.relativize(paramFile.toPath()).toString())).filter(paramString2 -> paramString2.toLowerCase(Locale.US).startsWith(paramString1.toLowerCase(Locale.US))).filter(paramString -> !paramString.contains(" "));
  }
  
  @Deprecated
  public static File gameDir() {
    return gameDir(Helper.mc);
  }
  
  public static File gameDir(fqq paramfqq) {
    File file;
    return (file = paramfqq.q.getAbsoluteFile()).getName().equals(".") ? file.getParentFile() : file;
  }
}
