package baritone.api.command.datatypes;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypePost;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum RelativeCoordinate implements IDatatypePost<Double, Double> {
  INSTANCE;
  
  private static String ScalesAliasRegex;
  
  private static Pattern PATTERN;
  
  public final Double apply(IDatatypeContext paramIDatatypeContext, Double paramDouble) {
    if (paramDouble == null)
      paramDouble = Double.valueOf(0.0D); 
    Matcher matcher;
    if (!(matcher = PATTERN.matcher(paramIDatatypeContext.getConsumer().getString())).matches())
      throw new IllegalArgumentException("pattern doesn't match"); 
    boolean bool = !matcher.group(1).isEmpty() ? true : false;
    double d = matcher.group(2).isEmpty() ? 0.0D : Double.parseDouble(matcher.group(2).replaceAll(ScalesAliasRegex, ""));
    if (matcher.group(2).toLowerCase().contains("k"))
      d *= 1000.0D; 
    if (matcher.group(2).toLowerCase().contains("m"))
      d *= 1000000.0D; 
    return bool ? Double.valueOf(paramDouble.doubleValue() + d) : Double.valueOf(d);
  }
  
  public final Stream<String> tabComplete(IDatatypeContext paramIDatatypeContext) {
    IArgConsumer iArgConsumer;
    return (!(iArgConsumer = paramIDatatypeContext.getConsumer()).has(2) && iArgConsumer.getString().matches("^(~|$)")) ? Stream.of("~") : Stream.empty();
  }
  
  static {
    PATTERN = Pattern.compile("^(~?)([+-]?(?:\\d+(?:\\.\\d*)?|\\.\\d+)(" + (ScalesAliasRegex = "[kKmM]") + "?)|)$");
  }
}
