package baritone.api.command.datatypes;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.IBaritone;
import baritone.api.cache.IWaypoint;
import baritone.api.cache.IWaypointCollection;
import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.helpers.TabCompleteHelper;
import java.util.Comparator;
import java.util.stream.Stream;

public enum ForWaypoints implements IDatatypeFor<IWaypoint[]> {
  INSTANCE;
  
  public final IWaypoint[] get(IDatatypeContext paramIDatatypeContext) {
    String str;
    IWaypoint.Tag tag;
    return ((tag = IWaypoint.Tag.getByName(str = paramIDatatypeContext.getConsumer().getString())) == null) ? getWaypointsByName(paramIDatatypeContext.getBaritone(), str) : getWaypointsByTag(paramIDatatypeContext.getBaritone(), tag);
  }
  
  public final Stream<String> tabComplete(IDatatypeContext paramIDatatypeContext) {
    return (new TabCompleteHelper()).append(getWaypointNames(paramIDatatypeContext.getBaritone())).sortAlphabetically().prepend(IWaypoint.Tag.getAllNames()).filterPrefix(paramIDatatypeContext.getConsumer().getString()).stream();
  }
  
  public static IWaypointCollection waypoints(IBaritone paramIBaritone) {
    return paramIBaritone.getWorldProvider().getCurrentWorld().getWaypoints();
  }
  
  public static IWaypoint[] getWaypoints(IBaritone paramIBaritone) {
    return (IWaypoint[])waypoints(paramIBaritone).getAllWaypoints().stream().sorted(Comparator.comparingLong(IWaypoint::getCreationTimestamp).reversed()).toArray(paramInt -> new IWaypoint[paramInt]);
  }
  
  public static String[] getWaypointNames(IBaritone paramIBaritone) {
    return (String[])Stream.<IWaypoint>of(getWaypoints(paramIBaritone)).map(IWaypoint::getName).filter(paramString -> !paramString.isEmpty()).toArray(paramInt -> new String[paramInt]);
  }
  
  public static IWaypoint[] getWaypointsByTag(IBaritone paramIBaritone, IWaypoint.Tag paramTag) {
    return (IWaypoint[])waypoints(paramIBaritone).getByTag(paramTag).stream().sorted(Comparator.comparingLong(IWaypoint::getCreationTimestamp).reversed()).toArray(paramInt -> new IWaypoint[paramInt]);
  }
  
  public static IWaypoint[] getWaypointsByName(IBaritone paramIBaritone, String paramString) {
    return (IWaypoint[])Stream.<IWaypoint>of(getWaypoints(paramIBaritone)).filter(paramIWaypoint -> paramIWaypoint.getName().equalsIgnoreCase(paramString)).toArray(paramInt -> new IWaypoint[paramInt]);
  }
}
