package baritone.api.command.argument;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.command.argument.ICommandArgument;
import baritone.api.command.datatypes.IDatatypeFor;
import baritone.api.command.datatypes.IDatatypePost;
import java.util.Deque;
import java.util.LinkedList;
import java.util.stream.Stream;

public interface IArgConsumer {
  LinkedList<ICommandArgument> getArgs();
  
  Deque<ICommandArgument> getConsumed();
  
  boolean has(int paramInt);
  
  boolean hasAny();
  
  boolean hasAtMost(int paramInt);
  
  boolean hasAtMostOne();
  
  boolean hasExactly(int paramInt);
  
  boolean hasExactlyOne();
  
  ICommandArgument peek(int paramInt);
  
  ICommandArgument peek();
  
  boolean is(Class<?> paramClass, int paramInt);
  
  boolean is(Class<?> paramClass);
  
  String peekString(int paramInt);
  
  String peekString();
  
  <E extends Enum<?>> E peekEnum(Class<E> paramClass, int paramInt);
  
  <E extends Enum<?>> E peekEnum(Class<E> paramClass);
  
  <E extends Enum<?>> E peekEnumOrNull(Class<E> paramClass, int paramInt);
  
  <E extends Enum<?>> E peekEnumOrNull(Class<E> paramClass);
  
  <T> T peekAs(Class<T> paramClass, int paramInt);
  
  <T> T peekAs(Class<T> paramClass);
  
  <T> T peekAsOrDefault(Class<T> paramClass, T paramT, int paramInt);
  
  <T> T peekAsOrDefault(Class<T> paramClass, T paramT);
  
  <T> T peekAsOrNull(Class<T> paramClass, int paramInt);
  
  <T> T peekAsOrNull(Class<T> paramClass);
  
  <T> T peekDatatype(IDatatypeFor<T> paramIDatatypeFor);
  
  <T, O> T peekDatatype(IDatatypePost<T, O> paramIDatatypePost);
  
  <T, O> T peekDatatype(IDatatypePost<T, O> paramIDatatypePost, O paramO);
  
  <T> T peekDatatypeOrNull(IDatatypeFor<T> paramIDatatypeFor);
  
  <T, O> T peekDatatypeOrNull(IDatatypePost<T, O> paramIDatatypePost);
  
  <T, O, D extends IDatatypePost<T, O>> T peekDatatypePost(D paramD, O paramO);
  
  <T, O, D extends IDatatypePost<T, O>> T peekDatatypePostOrDefault(D paramD, O paramO, T paramT);
  
  <T, O, D extends IDatatypePost<T, O>> T peekDatatypePostOrNull(D paramD, O paramO);
  
  <T, D extends IDatatypeFor<T>> T peekDatatypeFor(Class<D> paramClass);
  
  <T, D extends IDatatypeFor<T>> T peekDatatypeForOrDefault(Class<D> paramClass, T paramT);
  
  <T, D extends IDatatypeFor<T>> T peekDatatypeForOrNull(Class<D> paramClass);
  
  ICommandArgument get();
  
  String getString();
  
  <E extends Enum<?>> E getEnum(Class<E> paramClass);
  
  <E extends Enum<?>> E getEnumOrDefault(Class<E> paramClass, E paramE);
  
  <E extends Enum<?>> E getEnumOrNull(Class<E> paramClass);
  
  <T> T getAs(Class<T> paramClass);
  
  <T> T getAsOrDefault(Class<T> paramClass, T paramT);
  
  <T> T getAsOrNull(Class<T> paramClass);
  
  <T, O, D extends IDatatypePost<T, O>> T getDatatypePost(D paramD, O paramO);
  
  <T, O, D extends IDatatypePost<T, O>> T getDatatypePostOrDefault(D paramD, O paramO, T paramT);
  
  <T, O, D extends IDatatypePost<T, O>> T getDatatypePostOrNull(D paramD, O paramO);
  
  <T, D extends IDatatypeFor<T>> T getDatatypeFor(D paramD);
  
  <T, D extends IDatatypeFor<T>> T getDatatypeForOrDefault(D paramD, T paramT);
  
  <T, D extends IDatatypeFor<T>> T getDatatypeForOrNull(D paramD);
  
  <T extends baritone.api.command.datatypes.IDatatype> Stream<String> tabCompleteDatatype(T paramT);
  
  String rawRest();
  
  void requireMin(int paramInt);
  
  void requireMax(int paramInt);
  
  void requireExactly(int paramInt);
  
  boolean hasConsumed();
  
  ICommandArgument consumed();
  
  String consumedString();
  
  baritone.api.command.argument.IArgConsumer copy();
}
