package baritone.api.cache;

package .tmp;

import baritone.api.cache.IWaypoint;
import baritone.api.utils.BetterBlockPos;
import iw;
import java.util.Date;

public class Waypoint implements IWaypoint {
  private final String name;
  
  private final IWaypoint.Tag tag;
  
  private final long creationTimestamp;
  
  private final BetterBlockPos location;
  
  public Waypoint(String paramString, IWaypoint.Tag paramTag, BetterBlockPos paramBetterBlockPos) {
    this(paramString, paramTag, paramBetterBlockPos, System.currentTimeMillis());
  }
  
  public Waypoint(String paramString, IWaypoint.Tag paramTag, BetterBlockPos paramBetterBlockPos, long paramLong) {
    this.name = paramString;
    this.tag = paramTag;
    this.location = paramBetterBlockPos;
    this.creationTimestamp = paramLong;
  }
  
  public int hashCode() {
    return this.name.hashCode() ^ this.tag.hashCode() ^ this.location.hashCode() ^ Long.hashCode(this.creationTimestamp);
  }
  
  public String getName() {
    return this.name;
  }
  
  public IWaypoint.Tag getTag() {
    return this.tag;
  }
  
  public long getCreationTimestamp() {
    return this.creationTimestamp;
  }
  
  public BetterBlockPos getLocation() {
    return this.location;
  }
  
  public String toString() {
    return String.format("%s %s %s", new Object[] { this.name, BetterBlockPos.from((iw)this.location).toString(), (new Date(this.creationTimestamp)).toString() });
  }
  
  public boolean equals(Object paramObject) {
    if (paramObject == null)
      return false; 
    if (!(paramObject instanceof IWaypoint))
      return false; 
    paramObject = paramObject;
    return (this.name.equals(paramObject.getName()) && this.tag == paramObject.getTag() && this.location.equals(paramObject.getLocation()));
  }
}
