package baritone.api.cache;

package .tmp;

import baritone.api.cache.IWaypoint;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public enum Tag {
  HOME(new String[] { "home", "base" }),
  DEATH(new String[] { "death" }),
  BED(new String[] { "bed", "spawn" }),
  USER(new String[] { "user" });
  
  private static final List<Tag> TAG_LIST;
  
  public final String[] names;
  
  Tag(String... paramVarArgs) {
    this.names = paramVarArgs;
  }
  
  public final String getName() {
    return this.names[0];
  }
  
  public static Tag getByName(String paramString) {
    Tag[] arrayOfTag;
    int i = (arrayOfTag = values()).length;
    for (byte b = 0; b < i; b++) {
      Tag tag;
      String[] arrayOfString;
      int j = (arrayOfString = (tag = arrayOfTag[b]).names).length;
      for (byte b1 = 0; b1 < j; b1++) {
        if (arrayOfString[b1].equalsIgnoreCase(paramString))
          return tag; 
      } 
    } 
    return null;
  }
  
  public static String[] getAllNames() {
    HashSet hashSet = new HashSet();
    Tag[] arrayOfTag;
    int i = (arrayOfTag = values()).length;
    for (byte b = 0; b < i; b++) {
      Tag tag = arrayOfTag[b];
      hashSet.addAll(Arrays.asList(tag.names));
    } 
    return (String[])hashSet.toArray((Object[])new String[0]);
  }
  
  static {
    TAG_LIST = Collections.unmodifiableList(Arrays.asList(values()));
  }
}
