package baritone.api.behavior;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.behavior.IBehavior;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.calc.IPathFinder;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.path.IPathExecutor;
import java.util.Optional;

public interface IPathingBehavior extends IBehavior {
  default Optional<Double> ticksRemainingInSegment() {
    return ticksRemainingInSegment(true);
  }
  
  default Optional<Double> ticksRemainingInSegment(boolean paramBoolean) {
    IPathExecutor iPathExecutor;
    if ((iPathExecutor = getCurrent()) == null)
      return Optional.empty(); 
    int i = paramBoolean ? iPathExecutor.getPosition() : (iPathExecutor.getPosition() + 1);
    return Optional.of(Double.valueOf(iPathExecutor.getPath().ticksRemainingFrom(i)));
  }
  
  Optional<Double> estimatedTicksToGoal();
  
  Goal getGoal();
  
  boolean isPathing();
  
  default boolean hasPath() {
    return (getCurrent() != null);
  }
  
  boolean cancelEverything();
  
  void forceCancel();
  
  default Optional<IPath> getPath() {
    return Optional.<IPathExecutor>ofNullable(getCurrent()).map(IPathExecutor::getPath);
  }
  
  Optional<? extends IPathFinder> getInProgress();
  
  IPathExecutor getCurrent();
  
  IPathExecutor getNext();
}
