package baritone.api;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.Settings.JavaOnly;
import baritone.api.utils.Helper;
import baritone.api.utils.NotificationHelper;
import baritone.api.utils.gui.BaritoneToast;
import dag;
import dno;
import dnq;
import dsr;
import dui;
import fqk;
import fqq;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xg;

public final class Settings {
  private static final Logger LOGGER = LoggerFactory.getLogger("Baritone");
  
  public final Setting<Boolean> allowBreak = new Setting(this, Boolean.TRUE);
  
  public final Setting<List<dno>> allowBreakAnyway = new Setting(this, new ArrayList());
  
  public final Setting<Boolean> allowSprint = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowPlace = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowPlaceInFluidsSource = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowPlaceInFluidsFlow = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowInventory = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> ticksBetweenInventoryMoves = new Setting(this, Integer.valueOf(1));
  
  public final Setting<Boolean> inventoryMoveOnlyIfStationary = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> assumeExternalAutoTool = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> autoTool = new Setting(this, Boolean.TRUE);
  
  public final Setting<Double> blockPlacementPenalty = new Setting(this, Double.valueOf(20.0D));
  
  public final Setting<Double> blockBreakAdditionalPenalty = new Setting(this, Double.valueOf(2.0D));
  
  public final Setting<Double> jumpPenalty = new Setting(this, Double.valueOf(2.0D));
  
  public final Setting<Double> walkOnWaterOnePenalty = new Setting(this, Double.valueOf(3.0D));
  
  public final Setting<Boolean> strictLiquidCheck = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowWaterBucketFall = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> assumeWalkOnWater = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> assumeWalkOnLava = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> assumeStep = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> assumeSafeWalk = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowJumpAtBuildLimit = new Setting(this, Boolean.FALSE);
  
  @Deprecated
  @JavaOnly
  public final Setting<Boolean> allowJumpAt256 = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowParkourAscend = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowDiagonalDescend = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowDiagonalAscend = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowDownward = new Setting(this, Boolean.TRUE);
  
  public final Setting<List<dag>> acceptableThrowawayItems = new Setting(this, new ArrayList(Arrays.asList((Object[])new dag[] { dnq.j.h(), dnq.m.h(), dnq.em.h(), dnq.b.h() })));
  
  public final Setting<List<dno>> blocksToAvoid = new Setting(this, new ArrayList());
  
  public final Setting<List<dno>> blocksToDisallowBreaking = new Setting(this, new ArrayList());
  
  public final Setting<List<dno>> blocksToAvoidBreaking = new Setting(this, new ArrayList(Arrays.asList((Object[])new dno[] { dnq.cL, dnq.cO, dnq.cG, dnq.hw })));
  
  public final Setting<Double> avoidBreakingMultiplier = new Setting(this, Double.valueOf(0.1D));
  
  public final Setting<List<dno>> buildIgnoreBlocks = new Setting(this, new ArrayList(Arrays.asList((Object[])new dno[0])));
  
  public final Setting<List<dno>> buildSkipBlocks = new Setting(this, new ArrayList(Arrays.asList((Object[])new dno[0])));
  
  public final Setting<Map<dno, List<dno>>> buildValidSubstitutes = new Setting(this, new HashMap<>());
  
  public final Setting<Map<dno, List<dno>>> buildSubstitutes = new Setting(this, new HashMap<>());
  
  public final Setting<List<dno>> okIfAir = new Setting(this, new ArrayList(Arrays.asList((Object[])new dno[0])));
  
  public final Setting<Boolean> buildIgnoreExisting = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> buildIgnoreDirection = new Setting(this, Boolean.FALSE);
  
  public final Setting<List<String>> buildIgnoreProperties = new Setting(this, new ArrayList(Arrays.asList((Object[])new String[0])));
  
  public final Setting<Boolean> avoidUpdatingFallingBlocks = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowVines = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowWalkOnBottomSlab = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> allowParkour = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> allowParkourPlace = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> considerPotionEffects = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> sprintAscends = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> overshootTraverse = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> pauseMiningForFallingBlocks = new Setting(this, Boolean.TRUE);
  
  public final Setting<Integer> rightClickSpeed = new Setting(this, Integer.valueOf(4));
  
  public final Setting<Double> randomLooking113 = new Setting(this, Double.valueOf(2.0D));
  
  public final Setting<Float> blockReachDistance = new Setting(this, Float.valueOf(4.5F));
  
  public final Setting<Integer> blockBreakSpeed = new Setting(this, Integer.valueOf(6));
  
  public final Setting<Double> randomLooking = new Setting(this, Double.valueOf(0.01D));
  
  public final Setting<Double> costHeuristic = new Setting(this, Double.valueOf(3.563D));
  
  public final Setting<Integer> pathingMaxChunkBorderFetch = new Setting(this, Integer.valueOf(50));
  
  public final Setting<Double> backtrackCostFavoringCoefficient = new Setting(this, Double.valueOf(0.5D));
  
  public final Setting<Boolean> avoidance = new Setting(this, Boolean.FALSE);
  
  public final Setting<Double> mobSpawnerAvoidanceCoefficient = new Setting(this, Double.valueOf(2.0D));
  
  public final Setting<Integer> mobSpawnerAvoidanceRadius = new Setting(this, Integer.valueOf(16));
  
  public final Setting<Double> mobAvoidanceCoefficient = new Setting(this, Double.valueOf(1.5D));
  
  public final Setting<Integer> mobAvoidanceRadius = new Setting(this, Integer.valueOf(8));
  
  public final Setting<Boolean> rightClickContainerOnArrival = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> enterPortal = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> minimumImprovementRepropagation = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> cutoffAtLoadBoundary = new Setting(this, Boolean.FALSE);
  
  public final Setting<Double> maxCostIncrease = new Setting(this, Double.valueOf(10.0D));
  
  public final Setting<Integer> costVerificationLookahead = new Setting(this, Integer.valueOf(5));
  
  public final Setting<Double> pathCutoffFactor = new Setting(this, Double.valueOf(0.9D));
  
  public final Setting<Integer> pathCutoffMinimumLength = new Setting(this, Integer.valueOf(30));
  
  public final Setting<Integer> planningTickLookahead = new Setting(this, Integer.valueOf(150));
  
  public final Setting<Integer> pathingMapDefaultSize = new Setting(this, Integer.valueOf(1024));
  
  public final Setting<Float> pathingMapLoadFactor = new Setting(this, Float.valueOf(0.75F));
  
  public final Setting<Integer> maxFallHeightNoWater = new Setting(this, Integer.valueOf(3));
  
  public final Setting<Integer> maxFallHeightBucket = new Setting(this, Integer.valueOf(20));
  
  public final Setting<Boolean> allowOvershootDiagonalDescend = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> simplifyUnloadedYCoord = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> repackOnAnyBlockChange = new Setting(this, Boolean.TRUE);
  
  public final Setting<Integer> movementTimeoutTicks = new Setting(this, Integer.valueOf(100));
  
  public final Setting<Long> primaryTimeoutMS = new Setting(this, Long.valueOf(500L));
  
  public final Setting<Long> failureTimeoutMS = new Setting(this, Long.valueOf(2000L));
  
  public final Setting<Long> planAheadPrimaryTimeoutMS = new Setting(this, Long.valueOf(4000L));
  
  public final Setting<Long> planAheadFailureTimeoutMS = new Setting(this, Long.valueOf(5000L));
  
  public final Setting<Boolean> slowPath = new Setting(this, Boolean.FALSE);
  
  public final Setting<Long> slowPathTimeDelayMS = new Setting(this, Long.valueOf(100L));
  
  public final Setting<Long> slowPathTimeoutMS = new Setting(this, Long.valueOf(40000L));
  
  public final Setting<Boolean> doBedWaypoints = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> doDeathWaypoints = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> chunkCaching = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> pruneRegionsFromRAM = new Setting(this, Boolean.TRUE);
  
  public final Setting<Integer> chunkPackerQueueMaxSize = new Setting(this, Integer.valueOf(2000));
  
  public final Setting<Boolean> backfill = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> logAsToast = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> chatDebug = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> chatControl = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> chatControlAnyway = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> renderPath = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderPathAsLine = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> renderGoal = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderGoalAnimated = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderSelectionBoxes = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderGoalIgnoreDepth = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderGoalXZBeacon = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> renderSelectionBoxesIgnoreDepth = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderPathIgnoreDepth = new Setting(this, Boolean.TRUE);
  
  public final Setting<Float> pathRenderLineWidthPixels = new Setting(this, Float.valueOf(5.0F));
  
  public final Setting<Float> goalRenderLineWidthPixels = new Setting(this, Float.valueOf(3.0F));
  
  public final Setting<Boolean> fadePath = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> freeLook = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> blockFreeLook = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> elytraFreeLook = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> smoothLook = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> elytraSmoothLook = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> smoothLookTicks = new Setting(this, Integer.valueOf(5));
  
  public final Setting<Boolean> remainWithExistingLookDirection = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> antiCheatCompatibility = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> pathThroughCachedOnly = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> sprintInWater = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> blacklistClosestOnFailure = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> renderCachedChunks = new Setting(this, Boolean.FALSE);
  
  public final Setting<Float> cachedChunksOpacity = new Setting(this, Float.valueOf(0.5F));
  
  public final Setting<Boolean> prefixControl = new Setting(this, Boolean.TRUE);
  
  public final Setting<String> prefix = new Setting(this, "#");
  
  public final Setting<Boolean> shortBaritonePrefix = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> useMessageTag = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> echoCommands = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> censorCoordinates = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> censorRanCommands = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> itemSaver = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> itemSaverThreshold = new Setting(this, Integer.valueOf(10));
  
  public final Setting<Boolean> preferSilkTouch = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> walkWhileBreaking = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> splicePath = new Setting(this, Boolean.TRUE);
  
  public final Setting<Integer> maxPathHistoryLength = new Setting(this, Integer.valueOf(300));
  
  public final Setting<Integer> pathHistoryCutoffAmount = new Setting(this, Integer.valueOf(50));
  
  public final Setting<Integer> mineGoalUpdateInterval = new Setting(this, Integer.valueOf(5));
  
  public final Setting<Integer> maxCachedWorldScanCount = new Setting(this, Integer.valueOf(10));
  
  public final Setting<Integer> mineMaxOreLocationsCount = new Setting(this, Integer.valueOf(64));
  
  public final Setting<Integer> minYLevelWhileMining = new Setting(this, Integer.valueOf(0));
  
  public final Setting<Integer> maxYLevelWhileMining = new Setting(this, Integer.valueOf(2031));
  
  public final Setting<Boolean> allowOnlyExposedOres = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> allowOnlyExposedOresDistance = new Setting(this, Integer.valueOf(1));
  
  public final Setting<Boolean> exploreForBlocks = new Setting(this, Boolean.TRUE);
  
  public final Setting<Integer> worldExploringChunkOffset = new Setting(this, Integer.valueOf(0));
  
  public final Setting<Integer> exploreChunkSetMinimumSize = new Setting(this, Integer.valueOf(10));
  
  public final Setting<Integer> exploreMaintainY = new Setting(this, Integer.valueOf(64));
  
  public final Setting<Boolean> replantCrops = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> replantNetherWart = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> farmMaxScanSize = new Setting(this, Integer.valueOf(256));
  
  public final Setting<Boolean> extendCacheOnThreshold = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> buildInLayers = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> layerOrder = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> layerHeight = new Setting(this, Integer.valueOf(1));
  
  public final Setting<Integer> startAtLayer = new Setting(this, Integer.valueOf(0));
  
  public final Setting<Boolean> skipFailedLayers = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> buildOnlySelection = new Setting(this, Boolean.FALSE);
  
  public final Setting<kb> buildRepeat = new Setting(this, new kb(0, 0, 0));
  
  public final Setting<Integer> buildRepeatCount = new Setting(this, Integer.valueOf(-1));
  
  public final Setting<Boolean> buildRepeatSneaky = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> breakFromAbove = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> goalBreakFromAbove = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> mapArtMode = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> okIfWater = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> incorrectSize = new Setting(this, Integer.valueOf(100));
  
  public final Setting<Double> breakCorrectBlockPenaltyMultiplier = new Setting(this, Double.valueOf(10.0D));
  
  public final Setting<Double> placeIncorrectBlockPenaltyMultiplier = new Setting(this, Double.valueOf(2.0D));
  
  public final Setting<Boolean> schematicOrientationX = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> schematicOrientationY = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> schematicOrientationZ = new Setting(this, Boolean.FALSE);
  
  public final Setting<dui> buildSchematicRotation = new Setting(this, dui.a);
  
  public final Setting<dsr> buildSchematicMirror = new Setting(this, dsr.a);
  
  public final Setting<String> schematicFallbackExtension = new Setting(this, "schematic");
  
  public final Setting<Integer> builderTickScanRadius = new Setting(this, Integer.valueOf(5));
  
  public final Setting<Boolean> mineScanDroppedItems = new Setting(this, Boolean.TRUE);
  
  public final Setting<Long> mineDropLoiterDurationMSThanksLouca = new Setting(this, Long.valueOf(250L));
  
  public final Setting<Boolean> distanceTrim = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> cancelOnGoalInvalidation = new Setting(this, Boolean.TRUE);
  
  public final Setting<Integer> axisHeight = new Setting(this, Integer.valueOf(120));
  
  public final Setting<Boolean> disconnectOnArrival = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> legitMine = new Setting(this, Boolean.FALSE);
  
  public final Setting<Integer> legitMineYLevel = new Setting(this, Integer.valueOf(-59));
  
  public final Setting<Boolean> legitMineIncludeDiagonals = new Setting(this, Boolean.FALSE);
  
  public final Setting<Boolean> forceInternalMining = new Setting(this, Boolean.TRUE);
  
  public final Setting<Boolean> internalMiningAirException = new Setting(this, Boolean.TRUE);
  
  public final Setting<Double> followOffsetDistance = new Setting(this, Double.valueOf(0.0D));
  
  public final Setting<Float> followOffsetDirection = new Setting(this, Float.valueOf(0.0F));
  
  public final Setting<Integer> followRadius = new Setting(this, Integer.valueOf(3));
  
  public final Setting<Integer> followTargetMaxDistance = new Setting(this, Integer.valueOf(0));
  
  public final Setting<Boolean> disableCompletionCheck = new Setting(this, Boolean.FALSE);
  
  public final Setting<Long> cachedChunksExpirySeconds = new Setting(this, Long.valueOf(-1L));
  
  @JavaOnly
  public final Setting<Consumer<xg>> logger;
  
  @JavaOnly
  public final Setting<BiConsumer<String, Boolean>> notifier;
  
  @JavaOnly
  public final Setting<BiConsumer<xg, xg>> toaster;
  
  public final Setting<Boolean> verboseCommandExceptions;
  
  public final Setting<Double> yLevelBoxSize;
  
  public final Setting<Color> colorCurrentPath;
  
  public final Setting<Color> colorNextPath;
  
  public final Setting<Color> colorBlocksToBreak;
  
  public final Setting<Color> colorBlocksToPlace;
  
  public final Setting<Color> colorBlocksToWalkInto;
  
  public final Setting<Color> colorBestPathSoFar;
  
  public final Setting<Color> colorMostRecentConsidered;
  
  public final Setting<Color> colorGoalBox;
  
  public final Setting<Color> colorInvertedGoalBox;
  
  public final Setting<Color> colorSelection;
  
  public final Setting<Color> colorSelectionPos1;
  
  public final Setting<Color> colorSelectionPos2;
  
  public final Setting<Float> selectionOpacity;
  
  public final Setting<Float> selectionLineWidth;
  
  public final Setting<Boolean> renderSelection;
  
  public final Setting<Boolean> renderSelectionIgnoreDepth;
  
  public final Setting<Boolean> renderSelectionCorners;
  
  public final Setting<Boolean> useSwordToMine;
  
  public final Setting<Boolean> desktopNotifications;
  
  public final Setting<Boolean> notificationOnPathComplete;
  
  public final Setting<Boolean> notificationOnFarmFail;
  
  public final Setting<Boolean> notificationOnBuildFinished;
  
  public final Setting<Boolean> notificationOnExploreFinished;
  
  public final Setting<Boolean> notificationOnMineFail;
  
  public final Setting<Integer> elytraSimulationTicks;
  
  public final Setting<Integer> elytraPitchRange;
  
  public final Setting<Double> elytraFireworkSpeed;
  
  public final Setting<Integer> elytraFireworkSetbackUseDelay;
  
  public final Setting<Double> elytraMinimumAvoidance;
  
  public final Setting<Boolean> elytraConserveFireworks;
  
  public final Setting<Boolean> elytraRenderRaytraces;
  
  public final Setting<Boolean> elytraRenderHitboxRaytraces;
  
  public final Setting<Boolean> elytraRenderSimulation;
  
  public final Setting<Boolean> elytraAutoJump;
  
  public final Setting<Long> elytraNetherSeed;
  
  public final Setting<Boolean> elytraPredictTerrain;
  
  public final Setting<Boolean> elytraAutoSwap;
  
  public final Setting<Integer> elytraMinimumDurability;
  
  public final Setting<Integer> elytraMinFireworksBeforeLanding;
  
  public final Setting<Boolean> elytraAllowEmergencyLand;
  
  public final Setting<Long> elytraTimeBetweenCacheCullSecs;
  
  public final Setting<Integer> elytraCacheCullDistance;
  
  public final Setting<Boolean> elytraAllowLandOnNetherFortress;
  
  public final Setting<Boolean> elytraTermsAccepted;
  
  public final Setting<Boolean> elytraChatSpam;
  
  public final Map<String, Setting<?>> byLowerName;
  
  public final List<Setting<?>> allSettings;
  
  public final Map<Setting<?>, Type> settingTypes;
  
  Settings() {
    this.logger = new Setting(this, paramxg -> {
          try {
            fqk fqk = ((Boolean)this.useMessageTag.value).booleanValue() ? Helper.MESSAGE_TAG : null;
            (fqq.Q()).m.d().a(paramxg, null, fqk);
            return;
          } catch (Throwable throwable) {
            LOGGER.warn("Failed to log message to chat: " + paramxg.getString(), throwable);
            return;
          } 
        });
    this.notifier = new Setting(this, NotificationHelper::notify);
    this.toaster = new Setting(this, BaritoneToast::addOrUpdate);
    this.verboseCommandExceptions = new Setting(this, Boolean.FALSE);
    this.yLevelBoxSize = new Setting(this, Double.valueOf(15.0D));
    this.colorCurrentPath = new Setting(this, Color.RED);
    this.colorNextPath = new Setting(this, Color.MAGENTA);
    this.colorBlocksToBreak = new Setting(this, Color.RED);
    this.colorBlocksToPlace = new Setting(this, Color.GREEN);
    this.colorBlocksToWalkInto = new Setting(this, Color.MAGENTA);
    this.colorBestPathSoFar = new Setting(this, Color.BLUE);
    this.colorMostRecentConsidered = new Setting(this, Color.CYAN);
    this.colorGoalBox = new Setting(this, Color.GREEN);
    this.colorInvertedGoalBox = new Setting(this, Color.RED);
    this.colorSelection = new Setting(this, Color.CYAN);
    this.colorSelectionPos1 = new Setting(this, Color.BLACK);
    this.colorSelectionPos2 = new Setting(this, Color.ORANGE);
    this.selectionOpacity = new Setting(this, Float.valueOf(0.5F));
    this.selectionLineWidth = new Setting(this, Float.valueOf(2.0F));
    this.renderSelection = new Setting(this, Boolean.TRUE);
    this.renderSelectionIgnoreDepth = new Setting(this, Boolean.TRUE);
    this.renderSelectionCorners = new Setting(this, Boolean.TRUE);
    this.useSwordToMine = new Setting(this, Boolean.TRUE);
    this.desktopNotifications = new Setting(this, Boolean.FALSE);
    this.notificationOnPathComplete = new Setting(this, Boolean.TRUE);
    this.notificationOnFarmFail = new Setting(this, Boolean.TRUE);
    this.notificationOnBuildFinished = new Setting(this, Boolean.TRUE);
    this.notificationOnExploreFinished = new Setting(this, Boolean.TRUE);
    this.notificationOnMineFail = new Setting(this, Boolean.TRUE);
    this.elytraSimulationTicks = new Setting(this, Integer.valueOf(20));
    this.elytraPitchRange = new Setting(this, Integer.valueOf(25));
    this.elytraFireworkSpeed = new Setting(this, Double.valueOf(1.2D));
    this.elytraFireworkSetbackUseDelay = new Setting(this, Integer.valueOf(15));
    this.elytraMinimumAvoidance = new Setting(this, Double.valueOf(0.2D));
    this.elytraConserveFireworks = new Setting(this, Boolean.FALSE);
    this.elytraRenderRaytraces = new Setting(this, Boolean.FALSE);
    this.elytraRenderHitboxRaytraces = new Setting(this, Boolean.FALSE);
    this.elytraRenderSimulation = new Setting(this, Boolean.TRUE);
    this.elytraAutoJump = new Setting(this, Boolean.FALSE);
    this.elytraNetherSeed = new Setting(this, Long.valueOf(146008555100680L));
    this.elytraPredictTerrain = new Setting(this, Boolean.FALSE);
    this.elytraAutoSwap = new Setting(this, Boolean.TRUE);
    this.elytraMinimumDurability = new Setting(this, Integer.valueOf(5));
    this.elytraMinFireworksBeforeLanding = new Setting(this, Integer.valueOf(5));
    this.elytraAllowEmergencyLand = new Setting(this, Boolean.TRUE);
    this.elytraTimeBetweenCacheCullSecs = new Setting(this, Long.valueOf(TimeUnit.MINUTES.toSeconds(3L)));
    this.elytraCacheCullDistance = new Setting(this, Integer.valueOf(5000));
    this.elytraAllowLandOnNetherFortress = new Setting(this, Boolean.FALSE);
    this.elytraTermsAccepted = new Setting(this, Boolean.FALSE);
    this.elytraChatSpam = new Setting(this, Boolean.FALSE);
    Field[] arrayOfField = getClass().getFields();
    HashMap<Object, Object> hashMap1 = new HashMap<>();
    ArrayList<Setting> arrayList = new ArrayList();
    HashMap<Object, Object> hashMap2 = new HashMap<>();
    try {
      int i = arrayOfField.length;
      for (byte b = 0; b < i; b++) {
        Field field;
        if ((field = arrayOfField[b]).getType().equals(Setting.class)) {
          Setting setting = (Setting)field.get(this);
          String str = field.getName();
          setting.name = str;
          setting.javaOnly = field.isAnnotationPresent((Class)JavaOnly.class);
          str = str.toLowerCase();
          if (hashMap1.containsKey(str))
            throw new IllegalStateException("Duplicate setting name"); 
          hashMap1.put(str, setting);
          arrayList.add(setting);
          hashMap2.put(setting, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
        } 
      } 
    } catch (IllegalAccessException illegalAccessException) {
      throw new IllegalStateException(illegalAccessException);
    } 
    this.byLowerName = Collections.unmodifiableMap(hashMap1);
    this.allSettings = Collections.unmodifiableList((List)arrayList);
    this.settingTypes = Collections.unmodifiableMap(hashMap2);
  }
  
  public final <T> List<Setting<T>> getAllValuesByType(Class<T> paramClass) {
    ArrayList<Setting> arrayList = new ArrayList();
    Iterator<Setting<?>> iterator = this.allSettings.iterator();
    while (iterator.hasNext()) {
      Setting setting;
      if ((setting = iterator.next()).getValueClass().equals(paramClass))
        arrayList.add(setting); 
    } 
    return (List)arrayList;
  }
}
