package baritone.api;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.Settings;
import baritone.api.utils.SettingsUtil;
import baritone.api.utils.TypeUtils;
import java.lang.reflect.Type;

public final class Setting<T> {
  public T value;
  
  public final T defaultValue;
  
  String name;
  
  boolean javaOnly;
  
  Setting(T paramT) {
    if (paramT == null)
      throw new IllegalArgumentException("Cannot determine value type class from null"); 
    this.value = paramT;
    this.defaultValue = paramT;
    this.javaOnly = false;
  }
  
  @Deprecated
  public final T get() {
    return this.value;
  }
  
  public final String getName() {
    return this.name;
  }
  
  public final Class<T> getValueClass() {
    return TypeUtils.resolveBaseClass(getType());
  }
  
  public final String toString() {
    return SettingsUtil.settingToString(this);
  }
  
  public final void reset() {
    this.value = this.defaultValue;
  }
  
  public final Type getType() {
    return (Type)Settings.this.settingTypes.get(this);
  }
  
  public final boolean isJavaOnly() {
    return this.javaOnly;
  }
}
