package baritone.api;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import baritone.api.IBaritone;
import baritone.api.cache.IWorldScanner;
import baritone.api.command.ICommandSystem;
import baritone.api.schematic.ISchematicSystem;
import fqq;
import glp;
import gqm;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public interface IBaritoneProvider {
  IBaritone getPrimaryBaritone();
  
  List<IBaritone> getAllBaritones();
  
  default IBaritone getBaritoneForPlayer(gqm paramgqm) {
    for (IBaritone iBaritone : getAllBaritones()) {
      if (Objects.equals(paramgqm, iBaritone.getPlayerContext().player()))
        return iBaritone; 
    } 
    return null;
  }
  
  default IBaritone getBaritoneForMinecraft(fqq paramfqq) {
    for (IBaritone iBaritone : getAllBaritones()) {
      if (Objects.equals(paramfqq, iBaritone.getPlayerContext().minecraft()))
        return iBaritone; 
    } 
    return null;
  }
  
  default IBaritone getBaritoneForConnection(glp paramglp) {
    Iterator<IBaritone> iterator = getAllBaritones().iterator();
    while (iterator.hasNext()) {
      IBaritone iBaritone;
      gqm gqm;
      if ((gqm = (iBaritone = iterator.next()).getPlayerContext().player()) != null && gqm.j == paramglp)
        return iBaritone; 
    } 
    return null;
  }
  
  IBaritone createBaritone(fqq paramfqq);
  
  boolean destroyBaritone(IBaritone paramIBaritone);
  
  IWorldScanner getWorldScanner();
  
  ICommandSystem getCommandSystem();
  
  ISchematicSystem getSchematicSystem();
}
