package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.IDatatype;
import baritone.api.command.datatypes.IDatatypePost;
import baritone.api.command.datatypes.RelativeBlockPos;
import baritone.api.command.datatypes.RelativeFile;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.utils.BetterBlockPos;
import baritone.ge;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import kb;
import org.apache.commons.io.FilenameUtils;

public final class ae extends Command {
  private final File a;
  
  public ae(a parama) {
    super((IBaritone)parama, new String[] { "build" });
    this.a = new File((parama.getPlayerContext().minecraft()).q, "schematics");
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    File file1;
    File file2;
    if (FilenameUtils.getExtension((file2 = file1 = ((File)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeFile.INSTANCE, this.a)).getAbsoluteFile()).getAbsolutePath()).isEmpty())
      file2 = new File(file2.getAbsolutePath() + "." + file2.getAbsolutePath()); 
    if (!file2.exists()) {
      if (file1.exists())
        throw new CommandInvalidStateException(String.format("Cannot load %s because I do not know which schematic format that is. Please rename the file to include the correct file extension.", new Object[] { file2 })); 
      throw new CommandInvalidStateException("Cannot find " + String.valueOf(file2));
    } 
    if (!ge.a.getByFile(file2).isPresent()) {
      StringJoiner stringJoiner = new StringJoiner(", ");
      Objects.requireNonNull(stringJoiner);
      ge.a.getFileExtensions().forEach(stringJoiner::add);
      throw new CommandInvalidStateException(String.format("Unsupported schematic format. Reckognized file extensions are: %s", new Object[] { stringJoiner }));
    } 
    BetterBlockPos betterBlockPos = this.ctx.playerFeet();
    if (paramIArgConsumer.hasAny()) {
      paramIArgConsumer.requireMax(3);
      betterBlockPos = (BetterBlockPos)paramIArgConsumer.getDatatypePost((IDatatypePost)RelativeBlockPos.INSTANCE, betterBlockPos);
    } else {
      paramIArgConsumer.requireMax(0);
    } 
    if (!this.baritone.getBuilderProcess().build(file2.getName(), file2, (kb)betterBlockPos))
      throw new CommandInvalidStateException("Couldn't load the schematic. Either your schematic is corrupt or this is a bug."); 
    logDirect(String.format("Successfully loaded schematic for building\nOrigin: %s", new Object[] { betterBlockPos }));
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    if (paramIArgConsumer.hasExactlyOne())
      return RelativeFile.tabComplete(paramIArgConsumer, this.a); 
    if (paramIArgConsumer.has(2)) {
      paramIArgConsumer.get();
      return paramIArgConsumer.tabCompleteDatatype((IDatatype)RelativeBlockPos.INSTANCE);
    } 
    return Stream.empty();
  }
  
  public final String getShortDesc() {
    return "Build a schematic";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "Build a schematic from a file.", "", "Usage:", "> build <filename> - Loads and builds '<filename>.schematic'", "> build <filename> <x> <y> <z> - Custom position" });
  }
}
