package baritone;

package .tmp;

import baritone.a;
import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.process.IGetToBlockProcess;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class ad extends Command {
  public ad(a parama) {
    super((IBaritone)parama, new String[] { "blacklist" });
  }
  
  public final void execute(String paramString, IArgConsumer paramIArgConsumer) {
    paramIArgConsumer.requireMax(0);
    IGetToBlockProcess iGetToBlockProcess;
    if (!(iGetToBlockProcess = this.baritone.getGetToBlockProcess()).isActive())
      throw new CommandInvalidStateException("GetToBlockProcess is not currently active"); 
    if (iGetToBlockProcess.blacklistClosest()) {
      logDirect("Blacklisted closest instances");
      return;
    } 
    throw new CommandInvalidStateException("No known locations, unable to blacklist");
  }
  
  public final Stream<String> tabComplete(String paramString, IArgConsumer paramIArgConsumer) {
    return Stream.empty();
  }
  
  public final String getShortDesc() {
    return "Blacklist closest block";
  }
  
  public final List<String> getLongDesc() {
    return Arrays.asList(new String[] { "While going to a block this command blacklists the closest block so that Baritone won't attempt to get to it.", "", "Usage:", "> blacklist" });
  }
}
