/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.util.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.greencat.shimmer.mixin.DrawContextAccessor;
import java.awt.Color;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class Rect {
    public static void draw2DRoundedRect(float x2, float y2, float width, float height, float radius, float z2, Color color, class_332 context) {
        Rect.draw2DRoundedRect(x2, y2, width, height, radius, z2, color, context, true, true, true, true);
    }

    public static void draw2DRoundedRect(float x2, float y2, float width, float height, float radius, float z2, Color color, class_332 context, boolean ... control) {
        class_4587 matrixStack = context.method_51448();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GlStateManager._enableBlend();
        Rect.drawRect(matrix, context, x2 + radius, y2, x2 + width - radius, y2 + height, z2, red, green, blue, alpha);
        Rect.drawRect(matrix, context, x2, y2 + radius, x2 + radius, y2 + height - radius, z2, red, green, blue, alpha);
        Rect.drawRect(matrix, context, x2 + width - radius, y2 + radius, x2 + width, y2 + height - radius, z2, red, green, blue, alpha);
        if (control.length > 0 && control[0]) {
            Rect.drawArc(matrix, context, x2 + radius, y2 + radius, radius, 180, 270, z2, red, green, blue, alpha);
        } else {
            Rect.drawRect(matrix, context, x2, y2, x2 + radius, y2 + radius, z2, red, green, blue, alpha);
        }
        if (control.length > 1 && control[1]) {
            Rect.drawArc(matrix, context, x2 + width - radius, y2 + radius, radius, 270, 360, z2, red, green, blue, alpha);
        } else {
            Rect.drawRect(matrix, context, x2 + width - radius, y2, x2 + width, y2 + radius, z2, red, green, blue, alpha);
        }
        if (control.length > 3 && control[3]) {
            Rect.drawArc(matrix, context, x2 + width - radius, y2 + height - radius, radius, 0, 90, z2, red, green, blue, alpha);
        } else {
            Rect.drawRect(matrix, context, x2 + width - radius, y2 + height - radius, x2 + width, y2 + height, z2, red, green, blue, alpha);
        }
        if (control.length > 2 && control[2]) {
            Rect.drawArc(matrix, context, x2 + radius, y2 + height - radius, radius, 90, 180, z2, red, green, blue, alpha);
        } else {
            Rect.drawRect(matrix, context, x2, y2 + height - radius, x2 + radius, y2 + height, z2, red, green, blue, alpha);
        }
        Rect.drawArc(matrix, context, 0.0f, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        Rect.drawRect(matrix, context, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        GlStateManager._disableBlend();
    }

    public static void drawRect(Matrix4f matrix, class_332 context, float x1, float y1, float x2, float y2, float z2, float r2, float g2, float b2, float a2) {
        class_4588 buffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_51784());
        buffer.method_22918(matrix, x1, y1, z2).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, x1, y2, z2).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, x2, y2, z2).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, x2, y1, z2).method_22915(r2, g2, b2, a2);
    }

    private static void drawArc(Matrix4f matrix, class_332 context, float x2, float y2, float radius, int startAngle, int endAngle, float z2, float r2, float g2, float b2, float a2) {
        class_4588 arcBuffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_62278());
        arcBuffer.method_22918(matrix, x2, y2, z2).method_22915(r2, g2, b2, a2);
        for (int i2 = startAngle; i2 <= endAngle; i2 += 5) {
            double angle = Math.toRadians(i2);
            float px = (float)((double)x2 + Math.cos(angle) * (double)radius);
            float py = (float)((double)y2 + Math.sin(angle) * (double)radius);
            arcBuffer.method_22918(matrix, px, py, z2).method_22915(r2, g2, b2, a2);
        }
    }

    public static void drawOutlinedRoundedRect(float x2, float y2, float width, float height, float radius, float z2, Color color, float thickness, class_332 context) {
        Rect.drawOutlinedRoundedRect(x2, y2, width, height, radius, z2, color, thickness, context, true, true, true, true);
    }

    public static void drawOutlinedRoundedRect(float x1, float y1, float width1, float height1, float radius1, float z2, Color color, float thickness, class_332 context, boolean ... control) {
        for (float i2 = 0.0f; i2 <= thickness; i2 += 0.1f) {
            float x2 = x1 + i2;
            float y2 = y1 + i2;
            float width = width1 - 2.0f * i2;
            float height = height1 - 2.0f * i2;
            float radius = radius1 - i2;
            class_4587 matrixStack = context.method_51448();
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            float red = (float)color.getRed() / 255.0f;
            float green = (float)color.getGreen() / 255.0f;
            float blue = (float)color.getBlue() / 255.0f;
            float alpha = (float)color.getAlpha() / 255.0f;
            GlStateManager._enableBlend();
            class_4588 lineBuffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_49043((double)1.0));
            RenderSystem.lineWidth((float)1.0f);
            if (control.length > 0 && control[0]) {
                Rect.drawArcOutline(matrix, lineBuffer, x2 + radius, y2 + radius, radius, 180, 270, z2, red, green, blue, alpha);
            } else {
                Rect.drawLine(matrix, lineBuffer, x2, y2, x2 + radius, y2, z2, red, green, blue, alpha);
                Rect.drawLine(matrix, lineBuffer, x2, y2, x2, y2 + radius, z2, red, green, blue, alpha);
            }
            Rect.drawLine(matrix, lineBuffer, x2 + radius, y2, x2 + width - radius, y2, z2, red, green, blue, alpha);
            if (control.length > 1 && control[1]) {
                Rect.drawArcOutline(matrix, lineBuffer, x2 + width - radius, y2 + radius, radius, 270, 360, z2, red, green, blue, alpha);
            } else {
                Rect.drawLine(matrix, lineBuffer, x2 + width - radius, y2, x2 + width, y2, z2, red, green, blue, alpha);
                Rect.drawLine(matrix, lineBuffer, x2 + width, y2, x2 + width, y2 + radius, z2, red, green, blue, alpha);
            }
            Rect.drawLine(matrix, lineBuffer, x2 + width, y2 + radius, x2 + width, y2 + height - radius, z2, red, green, blue, alpha);
            if (control.length > 3 && control[3]) {
                Rect.drawArcOutline(matrix, lineBuffer, x2 + width - radius, y2 + height - radius, radius, 0, 90, z2, red, green, blue, alpha);
            } else {
                Rect.drawLine(matrix, lineBuffer, x2 + width - radius, y2 + height, x2 + width, y2 + height, z2, red, green, blue, alpha);
                Rect.drawLine(matrix, lineBuffer, x2 + width, y2 + height - radius, x2 + width, y2 + height, z2, red, green, blue, alpha);
            }
            Rect.drawLine(matrix, lineBuffer, x2 + radius, y2 + height, x2 + width - radius, y2 + height, z2, red, green, blue, alpha);
            if (control.length > 2 && control[2]) {
                Rect.drawArcOutline(matrix, lineBuffer, x2 + radius, y2 + height - radius, radius, 90, 180, z2, red, green, blue, alpha);
            } else {
                Rect.drawLine(matrix, lineBuffer, x2, y2 + height, x2 + radius, y2 + height, z2, red, green, blue, alpha);
                Rect.drawLine(matrix, lineBuffer, x2, y2 + height - radius, x2, y2 + height, z2, red, green, blue, alpha);
            }
            Rect.drawLine(matrix, lineBuffer, x2, y2 + radius, x2, y2 + height - radius, z2, red, green, blue, alpha);
            GlStateManager._disableBlend();
        }
    }

    private static void drawLine(Matrix4f matrix, class_4588 buffer, float x1, float y1, float x2, float y2, float z2, float r2, float g2, float b2, float a2) {
        buffer.method_22918(matrix, x1, y1, z2).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, x2, y2, z2).method_22915(r2, g2, b2, a2);
    }

    private static void drawArcOutline(Matrix4f matrix, class_4588 buffer, float x2, float y2, float radius, int startAngle, int endAngle, float z2, float r2, float g2, float b2, float a2) {
        float lastX = (float)((double)x2 + Math.cos(Math.toRadians(startAngle)) * (double)radius);
        float lastY = (float)((double)y2 + Math.sin(Math.toRadians(startAngle)) * (double)radius);
        for (int i2 = startAngle + 5; i2 <= endAngle; i2 += 5) {
            double angle = Math.toRadians(i2);
            float currentX = (float)((double)x2 + Math.cos(angle) * (double)radius);
            float currentY = (float)((double)y2 + Math.sin(angle) * (double)radius);
            Rect.drawLine(matrix, buffer, lastX, lastY, currentX, currentY, z2, r2, g2, b2, a2);
            lastX = currentX;
            lastY = currentY;
        }
    }
}

