/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.module.modules.render;

import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.util.entity.EntityUtil;
import dev.greencat.shimmer.util.render.RenderUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1439;
import net.minecraft.class_1550;
import net.minecraft.class_1614;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_745;

public class ESP
extends Module {
    public static final ModeSetting mode = new ModeSetting("Render Type", "Change Render Type", "3D", "3D", "2D", "Line");
    public final BooleanSetting useGuardian = new BooleanSetting("Elder Guardian", "Enable Elder Guardian ESP", true);
    public final BooleanSetting useSilverfish = new BooleanSetting("Silverfish", "Enable Silverfish ESP", true);
    public final BooleanSetting useGolem = new BooleanSetting("Iron Golem", "Enable Golem ESP", true);
    public final BooleanSetting usePlayer = new BooleanSetting("Player", "Enable Player ESP", true);
    private static final HashMap<String, Color> colorMap = new HashMap();

    public ESP() {
        super("ESP", "Allow you see Mob through the wall", -1, Module.Category.RENDER);
        this.addSettings(mode, this.useGuardian, this.useSilverfish, this.useGolem, this.usePlayer);
    }

    @Override
    public void onEnable() {
        if (this.useGuardian.isEnabled()) {
            colorMap.put(class_1550.class.getSimpleName(), new Color(0, 38, 255, 160));
        }
        if (this.useSilverfish.isEnabled()) {
            colorMap.put(class_1614.class.getSimpleName(), new Color(76, 255, 0, 160));
        }
        if (this.useGolem.isEnabled()) {
            colorMap.put(class_1439.class.getSimpleName(), new Color(255, 0, 0, 160));
        }
        if (this.usePlayer.isEnabled()) {
            colorMap.put(class_745.class.getSimpleName(), new Color(0, 255, 255, 160));
        }
        super.onEnable();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        colorMap.clear();
    }

    private static Color getColor(class_1297 entity) {
        if (entity instanceof class_1657) {
            if (entity.method_5476().method_10866().method_10973() != null) {
                return new Color(entity.method_5476().method_10866().method_10973().method_27716());
            }
            return colorMap.get(entity.getClass().getSimpleName());
        }
        return colorMap.get(entity.getClass().getSimpleName());
    }

    @ShimmerSubscribe
    public void onRender(RenderEvent.Post event) {
        if (ESP.mc.field_1687 == null || ESP.mc.field_1724 == null) {
            return;
        }
        for (class_1297 entity : ESP.mc.field_1687.method_18112()) {
            class_745 player;
            if (entity instanceof class_745 && EntityUtil.isNPC((class_1297)(player = (class_745)entity)) || !colorMap.containsKey(entity.getClass().getSimpleName())) continue;
            if (mode.getMode().equals("3D")) {
                RenderUtil.draw3DBox(RenderUtil.smoothen(entity, entity.method_5829(), event.wrc.tickCounter().method_60637(false)), ESP.getColor(entity), Objects.requireNonNull(event.wrc.matrixStack()), event.wrc);
                continue;
            }
            if (mode.getMode().equals("2D")) {
                if (entity instanceof class_1657) {
                    RenderUtil.draw2DOutlinePlayer(entity, ESP.getColor(entity), event.wrc.matrixStack(), event.wrc);
                    continue;
                }
                RenderUtil.draw2DOutline(entity, ESP.getColor(entity), event.wrc.matrixStack(), event.wrc);
                continue;
            }
            if (!mode.getMode().equals("Line")) continue;
            class_4184 camera = ESP.mc.field_1773.method_19418();
            class_243 start = new class_243(0.0, 0.0, 1.0).method_1037(-((float)Math.toRadians(camera.method_19329()))).method_1024(-((float)Math.toRadians(camera.method_19330())));
            class_243 end = RenderUtil.smoothen(entity, event.wrc.tickCounter().method_60637(false)).method_1031(0.0, (double)entity.method_5751(), 0.0);
            RenderUtil.draw3DLineFromPlayer(Objects.requireNonNull(event.wrc.matrixStack()), start, end, ESP.getColor(entity), event.wrc);
            RenderUtil.draw2DOutline(entity, ESP.getColor(entity), event.wrc.matrixStack(), event.wrc);
        }
    }
}

