/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.module;

import dev.greencat.core.type.settings.SettingBase;
import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.module.modules.render.Hud;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.KeybindSetting;
import dev.greencat.shimmer.util.player.rotation.ServerRotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public abstract class Module {
    public static final class_310 mc = class_310.method_1551();
    public String name;
    public String description;
    public KeybindSetting keyCode = new KeybindSetting(0);
    public Category category;
    public boolean enabled;
    public boolean needDisable = false;
    public List<Setting> settings = new ArrayList<Setting>();

    public Module(String name, String description, int key, Category category) {
        this(name, description, key, category, false);
    }

    public Module(String name, String description, int key, Category category, boolean useServerRotation) {
        this.name = name;
        this.description = description;
        this.keyCode.code = key;
        this.category = category;
        if (useServerRotation) {
            ServerRotation.registerServerRotationModule(name);
        }
        this.addSettings(this.keyCode);
    }

    public void addSettings(Setting ... settings) {
        this.settings.addAll(Arrays.asList(settings));
        this.settings.sort(Comparator.comparingInt(s2 -> s2 == this.keyCode ? 1 : 0));
    }

    public void onEnable() {
        Shimmer.getInstance().getEventBus().register(this);
        Shimmer.getInstance().getModuleManager().refreshEnabled();
        class_5250 title = class_2561.method_43470((String)"Module Manager");
        class_5250 content = class_2561.method_43470((String)this.getName());
        class_5250 end = class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "Enabled"));
        Hud.onMessage(new class_2561[]{title, content, end});
    }

    public void onDisable() {
        Shimmer.getInstance().getEventBus().unregister(this);
        Shimmer.getInstance().getModuleManager().refreshEnabled();
        class_5250 title = class_2561.method_43470((String)"Module Manager");
        class_5250 content = class_2561.method_43470((String)this.getName());
        class_5250 end = class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "Disabled"));
        Hud.onMessage(new class_2561[]{title, content, end});
    }

    public void toggle() {
        boolean bl2 = this.enabled = !this.enabled;
        if (this.enabled) {
            this.onEnable();
        } else {
            this.onDisable();
        }
        if (Shimmer.getInstance().moduleEnabledMap.get(this.name) != null) {
            Shimmer.getInstance().factory.setValue((SettingBase)Shimmer.getInstance().moduleEnabledMap.get(this.name), (Object)this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.toggle();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getKey() {
        return this.keyCode.code;
    }

    public void setKey(int key) {
        this.keyCode.code = key;
    }

    public static enum Category {
        COMBAT,
        MOVEMENT,
        RENDER,
        MACRO,
        PLAYER,
        MISC;

    }
}

