/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer;

import dev.greencat.MaterialConfig;
import dev.greencat.MaterialConfigFactory;
import dev.greencat.core.type.Category;
import dev.greencat.core.type.settings.BooleanSettings;
import dev.greencat.core.type.settings.KeybindSettings;
import dev.greencat.core.type.settings.ModeSettings;
import dev.greencat.core.type.settings.NumberSettings;
import dev.greencat.core.type.settings.SettingBase;
import dev.greencat.core.type.settings.StringSettings;
import dev.greencat.shimmer.command.CommandManager;
import dev.greencat.shimmer.event.events.ActionBarRenderEvent;
import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.event.events.WorldChangeEvent;
import dev.greencat.shimmer.eventbus.EventBus;
import dev.greencat.shimmer.keybind.VanillaKeyBind;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.ModuleManager;
import dev.greencat.shimmer.module.modules.misc.Cat;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.SettingManager;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.KeybindSetting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.setting.settings.StringSetting;
import dev.greencat.shimmer.util.HaikuLogger;
import dev.greencat.shimmer.util.IconLoader;
import dev.greencat.shimmer.util.RankingOverrider;
import dev.greencat.shimmer.util.irc.IRC;
import dev.greencat.shimmer.util.player.WalkerUtils;
import dev.greencat.shimmer.util.player.rotation.SmoothRotation;
import dev.greencat.shimmer.util.render.ShimmerRenderPipelines;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import dev.greencat.shimmer.util.render.animation.AnimationManager;
import dev.greencat.shimmer.util.world.LocationUtils;
import dev.greencat.shimmer.util.world.TPSUtil;
import dev.greencat.utils.color.ColorPalette;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1059;
import net.minecraft.class_10811;
import net.minecraft.class_1087;
import net.minecraft.class_155;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class Shimmer
implements ModInitializer {
    public static final String MOD_NAME = "Shimmer Neon";
    public static final String MOD_VERSION = "202";
    public static final class_310 mc = class_310.method_1551();
    public HashMap<String, BooleanSettings> moduleEnabledMap = new HashMap();
    public boolean lastHasWorld = false;
    public boolean isIRCToggled = false;
    private static Shimmer INSTANCE;
    private final VanillaKeyBind keyBind = new VanillaKeyBind();
    private final EventBus EVENT_BUS = new EventBus();
    private final ModuleManager MODULE_MANAGER = new ModuleManager();
    private final CommandManager COMMAND_MANAGER = new CommandManager();
    private final SettingManager SETTING_MANAGER = new SettingManager();
    private final RankingOverrider RANKING_OVERRIDER = new RankingOverrider();
    public int guiCustomR = 0;
    public int guiCustomG = 0;
    public int guiCustomB = 0;
    public final MaterialConfigFactory factory = new MaterialConfigFactory("Shimmer");
    public IRC IRC;
    private String title = "Shimmer Neon v202";
    public boolean isSorted = false;
    private final AnimationManager ANIMATION_MANAGER = new AnimationManager();

    public Shimmer() {
        INSTANCE = this;
    }

    public static Shimmer getInstance() {
        return INSTANCE;
    }

    public void onInitialize() {
        HaikuLogger.logger.info("Shimmer Neon v202 (phase 1) has initialized!");
        WorldRenderEvents.START.register(wrc -> {
            RenderEvent.Pre event = new RenderEvent.Pre(wrc);
            Shimmer.getInstance().getEventBus().post(event);
        });
        WorldRenderEvents.LAST.register(wrc -> {
            RenderEvent.Post event = new RenderEvent.Post(wrc);
            Shimmer.getInstance().getEventBus().post(event);
        });
        WorldRenderEvents.AFTER_ENTITIES.register(wrc -> {
            RenderEvent.AfterEntities event = new RenderEvent.AfterEntities(wrc);
            Shimmer.getInstance().getEventBus().post(event);
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (class_310.method_1551().field_1687 != null) {
                LocationUtils.update();
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((text, overlay) -> {
            ActionBarRenderEvent event = new ActionBarRenderEvent(text);
            Shimmer.getInstance().getEventBus().post(event);
            return true;
        });
        ClientTickEvents.START_CLIENT_TICK.register(SmoothRotation::onTick);
        ClientTickEvents.START_CLIENT_TICK.register(WalkerUtils::handleRotation);
        ClientTickEvents.START_CLIENT_TICK.register(mc -> {
            if (!this.lastHasWorld && mc.field_1687 != null) {
                HaikuLogger.info("[IRC] IRC\u5df2\u94fe\u63a5,\u8f93\u5165\"!disconnect\"\u65ad\u5f00\u94fe\u63a5,\"!\u6d88\u606f\"\u53d1\u9001\u6d88\u606f");
                HaikuLogger.info("[IRC] \u8f93\u5165\"!list\"\u67e5\u770b\u5f53\u524d\u73a9\u5bb6\u5217\u8868,\"!toggle\"\u6765\u5c06IRC\u8bbe\u4e3a\u9ed8\u8ba4\u804a\u5929\u9891\u9053");
            }
            this.lastHasWorld = mc.field_1687 != null;
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> {
            WorldChangeEvent event = new WorldChangeEvent();
            Shimmer.getInstance().getEventBus().post(event);
        });
        HudRenderCallback.EVENT.register(TextRenderUtil::onRenderHUD);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            if (!LocationUtils.sideBarString.toLowerCase().contains("village")) {
                return;
            }
            class_2680 blockState = class_10811.method_68014((boolean)false, (boolean)true);
            class_1087 blockStateModel = class_310.method_1551().method_1541().method_3349(blockState);
            class_4597 vertexConsumerProvider = context.consumers();
            class_4587 matrixStack = context.matrixStack();
            if (matrixStack == null || vertexConsumerProvider == null) {
                return;
            }
            matrixStack.method_22903();
            class_243 pos = context.camera().method_19326();
            matrixStack.method_22904(-pos.field_1352 + Cat.RENDER_POSITION.field_1352 + 1.0, -pos.field_1351 + Cat.RENDER_POSITION.field_1351, -pos.field_1350 + Cat.RENDER_POSITION.field_1350 + 1.0 + 0.0125);
            matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
            class_4587.class_4665 peek = matrixStack.method_23760();
            class_778.method_3367((class_4587.class_4665)peek, (class_4588)vertexConsumerProvider.getBuffer(class_1921.method_62290((class_2960)class_1059.field_5275)), (class_1087)blockStateModel, (float)1.0f, (float)1.0f, (float)1.0f, (int)15, (int)class_4608.field_21444);
            matrixStack.method_46416(1.0f, 1.0f, 0.0f);
            matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            Matrix4f matrix4f = peek.method_23761();
            class_4588 cat = vertexConsumerProvider.getBuffer(class_1921.method_23028((class_2960)Cat.TEXTURE));
            float z2 = 0.9370117f;
            cat.method_22918(matrix4f, 0.0f, 1.0f, z2).method_39415(-1).method_22913(0.0f, 1.0f).method_60803(15);
            cat.method_22918(matrix4f, 1.0f, 1.0f, z2).method_39415(-1).method_22913(1.0f, 1.0f).method_60803(15);
            cat.method_22918(matrix4f, 1.0f, 0.0f, z2).method_39415(-1).method_22913(1.0f, 0.0f).method_60803(15);
            cat.method_22918(matrix4f, 0.0f, 0.0f, z2).method_39415(-1).method_22913(0.0f, 0.0f).method_60803(15);
            matrixStack.method_22909();
            matrixStack.method_22903();
            matrixStack.method_22904(-pos.field_1352 + Cat.BIG_RENDER_POSITION.field_1352 + 1.0, -pos.field_1351 + Cat.BIG_RENDER_POSITION.field_1351, -pos.field_1350 + Cat.BIG_RENDER_POSITION.field_1350 + 1.0 + 0.0125);
            matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
            matrixStack.method_22905(7.0f, 7.0f, 1.0f);
            class_4587.class_4665 peek1 = matrixStack.method_23760();
            class_778.method_3367((class_4587.class_4665)peek1, (class_4588)vertexConsumerProvider.getBuffer(class_1921.method_62290((class_2960)class_1059.field_5275)), (class_1087)blockStateModel, (float)1.0f, (float)1.0f, (float)1.0f, (int)15, (int)class_4608.field_21444);
            matrixStack.method_46416(1.0f, 1.0f, 0.0f);
            matrixStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            Matrix4f matrix4f1 = peek1.method_23761();
            class_4588 cat1 = vertexConsumerProvider.getBuffer(class_1921.method_23028((class_2960)Cat.TEXTURE));
            cat1.method_22918(matrix4f1, 0.0f, 1.0f, z2).method_39415(-1).method_22913(0.0f, 1.0f).method_60803(15);
            cat1.method_22918(matrix4f1, 1.0f, 1.0f, z2).method_39415(-1).method_22913(1.0f, 1.0f).method_60803(15);
            cat1.method_22918(matrix4f1, 1.0f, 0.0f, z2).method_39415(-1).method_22913(1.0f, 0.0f).method_60803(15);
            cat1.method_22918(matrix4f1, 0.0f, 0.0f, z2).method_39415(-1).method_22913(0.0f, 0.0f).method_60803(15);
            matrixStack.method_22909();
        });
        new ShimmerRenderPipelines();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Shimmer.getInstance().IRC != null) {
                try {
                    Shimmer.getInstance().IRC.socket.close();
                    Shimmer.getInstance().IRC.reader.close();
                    Shimmer.getInstance().IRC.writer.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }));
    }

    public void postInitialize() {
        this.EVENT_BUS.register(TPSUtil.INSTANCE);
        HaikuLogger.logger.info("Registered TickRateUtil!");
        HaikuLogger.logger.info("Shimmer Neon v202 (phase 2) has initialized!");
        this.MODULE_MANAGER.getModule("AutoFish").setEnabled(false);
        try {
            IconLoader.setWindowIcons(class_310.method_1551().method_22683().method_4490(), "/assets/shimmer/logo.png");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.err.println("Cannot load icon!");
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (System.currentTimeMillis() - Cat.lastChange >= 20000L) {
                this.title = "Shimmer Neon v202";
                if (Cat.randomTitle.enabled) {
                    this.title = this.title + "  |  " + Cat.titles.getProperty(String.valueOf(Cat.random.nextInt(649) + 1));
                }
                Cat.lastChange = System.currentTimeMillis();
            }
            class_310.method_1551().method_22683().method_24286(this.title + " (Minecraft " + class_155.method_16673().method_48019() + ")");
        });
        try {
            this.IRC = new IRC();
            this.IRC.start();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        for (Module.Category category : Module.Category.values()) {
            this.factory.addCategory(new Category(category.name()));
        }
        for (Module module : Shimmer.getInstance().getModuleManager().getModules()) {
            String moduleName = module.getName();
            this.factory.addModule(new dev.greencat.core.type.Module(module.getCategory().name(), moduleName));
            BooleanSettings booleanSettings = new BooleanSettings(this.factory, moduleName, "isEnabled", false);
            this.factory.addSettings((SettingBase)booleanSettings, value -> module.setEnabled((Boolean)value.getValue()));
            this.factory.addCallback((settingBase, value) -> {
                if (settingBase.module.equals(booleanSettings.module) && settingBase.name.equals(booleanSettings.name)) {
                    module.setEnabled((Boolean)value);
                }
            });
            this.moduleEnabledMap.put(moduleName, booleanSettings);
            block20: for (Setting setting : module.settings) {
                String className;
                switch (className = setting.getClass().getSimpleName()) {
                    case "BooleanSetting": {
                        BooleanSetting originalSetting = (BooleanSetting)setting;
                        BooleanSettings wrapperSetting = new BooleanSettings(this.factory, moduleName, originalSetting.name, originalSetting.isEnabled());
                        this.factory.addSettings((SettingBase)wrapperSetting, value -> originalSetting.setEnabled((Boolean)value.getValue()));
                        this.factory.addCallback((settingBase, value) -> {
                            if (settingBase.name.equals(originalSetting.name) && moduleName.equals(settingBase.module)) {
                                originalSetting.setEnabled((Boolean)value);
                            }
                        });
                        continue block20;
                    }
                    case "NumberSetting": {
                        NumberSetting originalSetting1 = (NumberSetting)setting;
                        NumberSettings wrapperSetting1 = new NumberSettings(this.factory, moduleName, originalSetting1.name, Double.valueOf(originalSetting1.getValue()), Double.valueOf(originalSetting1.maximum), Double.valueOf(originalSetting1.minimum));
                        this.factory.addSettings((SettingBase)wrapperSetting1, value -> originalSetting1.setValue((Double)value.getValue()));
                        this.factory.addCallback((settingBase, value) -> {
                            if (settingBase.name.equals(originalSetting1.name) && moduleName.equals(settingBase.module)) {
                                originalSetting1.setValue((Double)value);
                            }
                        });
                        continue block20;
                    }
                    case "StringSetting": {
                        StringSetting originalSetting2 = (StringSetting)setting;
                        StringSettings wrapperSetting2 = new StringSettings(this.factory, moduleName, originalSetting2.name, originalSetting2.getString());
                        this.factory.addSettings((SettingBase)wrapperSetting2, value -> originalSetting2.setString((String)value.getValue()));
                        this.factory.addCallback((settingBase, value) -> {
                            if (settingBase.name.equals(originalSetting2.name) && moduleName.equals(settingBase.module)) {
                                originalSetting2.setString((String)value);
                            }
                        });
                        continue block20;
                    }
                    case "ModeSetting": {
                        ModeSetting originalSetting3 = (ModeSetting)setting;
                        ModeSettings wrapperSetting3 = new ModeSettings(this.factory, moduleName, originalSetting3.name, originalSetting3.getMode(), originalSetting3.getModes().toArray(new String[0]));
                        this.factory.addSettings((SettingBase)wrapperSetting3, value -> originalSetting3.setMode((String)value.getValue()));
                        this.factory.addCallback((settingBase, value) -> {
                            if (settingBase.name.equals(originalSetting3.name) && moduleName.equals(settingBase.module)) {
                                originalSetting3.setMode((String)value);
                            }
                        });
                        continue block20;
                    }
                    case "KeybindSetting": {
                        KeybindSetting originalSetting4 = (KeybindSetting)setting;
                        KeybindSettings wrapperSetting4 = new KeybindSettings(this.factory, moduleName, originalSetting4.name);
                        this.factory.addSettings((SettingBase)wrapperSetting4, value -> originalSetting4.setKeyCode((Integer)value.getValue()));
                        this.factory.addCallback((settingBase, value) -> {
                            if (settingBase.name.equals(originalSetting4.name) && moduleName.equals(settingBase.module)) {
                                originalSetting4.setKeyCode((Integer)value);
                            }
                        });
                        if (!module.name.equals("OneGui")) continue block20;
                        wrapperSetting4.setValue((Object)344);
                        continue block20;
                    }
                }
                HaikuLogger.logger.error("Unknown setting type: " + className);
            }
        }
        NumberSettings backgroundR = new NumberSettings(this.factory, "OneGui", "Background Custom R", Double.valueOf(175.0), Double.valueOf(255.0), Double.valueOf(1.0));
        NumberSettings backgroundG = new NumberSettings(this.factory, "OneGui", "Background Custom G", Double.valueOf(198.0), Double.valueOf(255.0), Double.valueOf(1.0));
        NumberSettings backgroundB = new NumberSettings(this.factory, "OneGui", "Background Custom B", Double.valueOf(255.0), Double.valueOf(255.0), Double.valueOf(1.0));
        NumberSettings backgroundAlpha = new NumberSettings(this.factory, "OneGui", "Background Custom Alpha", Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(0.0));
        ModeSettings backgroundDefault = new ModeSettings(this.factory, "OneGui", "Background Color", "Default White", new String[]{"Default White", "Default Dark", "Indigo", "Blue", "Purple", "Teal", "Orange", "Red", "Custom"});
        this.factory.addSettings((SettingBase)backgroundR, value -> {
            this.guiCustomR = ((Double)value.getValue()).intValue();
        });
        this.factory.addSettings((SettingBase)backgroundG, value -> {
            this.guiCustomG = ((Double)value.getValue()).intValue();
        });
        this.factory.addSettings((SettingBase)backgroundB, value -> {
            this.guiCustomB = ((Double)value.getValue()).intValue();
        });
        this.factory.addSettings((SettingBase)backgroundAlpha, value -> {
            MaterialConfig.backgroundAlpha = ((Double)value.getValue()).floatValue();
        });
        this.factory.addCallback((settingBase, value) -> {
            if (settingBase.name.equals(backgroundAlpha.name) && settingBase.module.equals(backgroundAlpha.module)) {
                MaterialConfig.backgroundAlpha = ((Double)value).floatValue();
            }
        });
        this.factory.addCallback((settingBase, value) -> {
            if (settingBase.name.equals(backgroundR.name) && settingBase.module.equals(backgroundR.module)) {
                this.guiCustomR = ((Double)value).intValue();
                if (((String)backgroundDefault.getValue()).equals("Custom")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
                }
            }
        });
        this.factory.addCallback((settingBase, value) -> {
            if (settingBase.name.equals(backgroundG.name) && settingBase.module.equals(backgroundG.module)) {
                this.guiCustomG = ((Double)value).intValue();
                if (((String)backgroundDefault.getValue()).equals("Custom")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
                }
            }
        });
        this.factory.addCallback((settingBase, value) -> {
            if (settingBase.name.equals(backgroundB.name) && settingBase.module.equals(backgroundB.module)) {
                this.guiCustomB = ((Double)value).intValue();
                if (((String)backgroundDefault.getValue()).equals("Custom")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
                }
            }
        });
        this.factory.addSettings((SettingBase)backgroundDefault, value -> {
            String valueStr = (String)value.getValue();
            if (valueStr.equals("Default White")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(175, 198, 255));
            }
            if (valueStr.equals("Default Dark")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(32, 33, 36));
            }
            if (valueStr.equals("Indigo")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(63, 81, 181));
            }
            if (valueStr.equals("Blue")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(33, 150, 243));
            }
            if (valueStr.equals("Purple")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(156, 39, 176));
            }
            if (valueStr.equals("Teal")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(0, 150, 136));
            }
            if (valueStr.equals("Orange")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(255, 152, 0));
            }
            if (valueStr.equals("Red")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(244, 67, 54));
            }
            if (valueStr.equals("Custom")) {
                MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
            }
        });
        this.factory.addCallback((settingBase, value) -> {
            if (settingBase.name.equals(backgroundDefault.name) && settingBase.module.equals(backgroundDefault.module)) {
                String valueStr = value.toString();
                if (valueStr.equals("Default White")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(175, 198, 255));
                }
                if (valueStr.equals("Default Dark")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(32, 33, 36));
                }
                if (valueStr.equals("Indigo")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(63, 81, 181));
                }
                if (valueStr.equals("Blue")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(33, 150, 243));
                }
                if (valueStr.equals("Purple")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(156, 39, 176));
                }
                if (valueStr.equals("Teal")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(0, 150, 136));
                }
                if (valueStr.equals("Orange")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(255, 152, 0));
                }
                if (valueStr.equals("Red")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(244, 67, 54));
                }
                if (valueStr.equals("Custom")) {
                    MaterialConfig.colorPalette = new ColorPalette(new Color(this.guiCustomR, this.guiCustomG, this.guiCustomB));
                }
            }
        });
    }

    public EventBus getEventBus() {
        return this.EVENT_BUS;
    }

    public ModuleManager getModuleManager() {
        return this.MODULE_MANAGER;
    }

    public CommandManager getCommandManager() {
        return this.COMMAND_MANAGER;
    }

    public SettingManager getSettingManager() {
        return this.SETTING_MANAGER;
    }

    public VanillaKeyBind getKeyBindManager() {
        return this.keyBind;
    }
}

