/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class IconLoader {
    private static final List<ByteBuffer> loadedIconPixels = new ArrayList<ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowIcons(long windowHandle, String ... iconPaths) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GLFWImage.Buffer icons = GLFWImage.malloc((int)iconPaths.length, (MemoryStack)stack);
            for (int i2 = 0; i2 < iconPaths.length; ++i2) {
                String iconPath = iconPaths[i2];
                ByteBuffer imageBuffer = null;
                ByteBuffer imageBytes = null;
                try (InputStream is = IconLoader.class.getResourceAsStream(iconPath);){
                    if (is == null) {
                        throw new IOException("Icon file not found: " + iconPath);
                    }
                    byte[] bytes = is.readAllBytes();
                    imageBytes = BufferUtils.createByteBuffer((int)bytes.length);
                    imageBytes.put(bytes).flip();
                    IntBuffer w2 = stack.mallocInt(1);
                    IntBuffer h2 = stack.mallocInt(1);
                    IntBuffer channels = stack.mallocInt(1);
                    imageBuffer = STBImage.stbi_load_from_memory((ByteBuffer)imageBytes, (IntBuffer)w2, (IntBuffer)h2, (IntBuffer)channels, (int)4);
                    if (imageBuffer == null) {
                        throw new IOException("Failed to load image " + iconPath + ": " + STBImage.stbi_failure_reason());
                    }
                    loadedIconPixels.add(imageBuffer);
                    int width = w2.get(0);
                    int height = h2.get(0);
                    ((GLFWImage)icons.get(i2)).width(width).height(height).pixels(imageBuffer);
                    continue;
                }
            }
            GLFW.glfwSetWindowIcon((long)windowHandle, (GLFWImage.Buffer)icons);
        }
        finally {
            IconLoader.cleanUpIcons();
        }
    }

    public static void cleanUpIcons() {
        for (ByteBuffer byteBuffer : loadedIconPixels) {
            STBImage.stbi_image_free((ByteBuffer)byteBuffer);
        }
        loadedIconPixels.clear();
    }
}

