/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.module.modules.misc;

import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class Translator
extends Module {
    public final ModeSetting language = new ModeSetting("Language", "Traget language", "Chinese", "Chinese", "Japanese");
    private String prevLanguage;
    private static TranslatorImpl translator = null;
    private long lastCheck = 0L;
    private long lastClear = 0L;

    public Translator() {
        super("Translator", "Translator your skyblock item name", -1, Module.Category.MISC);
        this.addSettings(this.language);
        this.prevLanguage = this.language.getMode();
        translator = new TranslatorImpl(this.getTranslateFileName(this.language.getMode()));
    }

    private String getTranslateFileName(String mode) {
        if (mode.equals("Chinese")) {
            return "zh_CN";
        }
        if (mode.equals("Japanese")) {
            return "ja_JP";
        }
        return null;
    }

    @ShimmerSubscribe
    public void onTick(TickEvent event) {
        if (System.currentTimeMillis() - this.lastCheck > 10000L && !this.prevLanguage.equals(this.language.getMode())) {
            this.lastCheck = System.currentTimeMillis();
            this.prevLanguage = this.language.getMode();
            translator = new TranslatorImpl(this.getTranslateFileName(this.language.getMode()));
        }
        if (System.currentTimeMillis() - this.lastClear >= 480000L && translator != null) {
            Translator.translator.translationCache.clear();
        }
    }

    public static String translate(String str) {
        return translator == null ? str : translator.translateItemName(str);
    }

    private static class TranslatorImpl {
        private final Properties reforgeTranslate;
        private final Properties itemNameTranslate;
        private final List<String> sortedReforgeKeys;
        private final List<String> sortedItemNameKeys;
        public final String name;
        private boolean isAvailable = true;
        private final HashMap<String, String> translationCache = new HashMap();

        public TranslatorImpl(String name) {
            this.name = name;
            this.reforgeTranslate = new Properties();
            this.itemNameTranslate = new Properties();
            InputStream reforgeProperties = Translator.class.getResourceAsStream("/assets/" + name + "/reforge.properties");
            InputStream itemNameProperties = Translator.class.getResourceAsStream("/assets/" + name + "/item.properties");
            try {
                this.reforgeTranslate.load(new InputStreamReader(reforgeProperties, StandardCharsets.UTF_8));
                this.itemNameTranslate.load(new InputStreamReader(itemNameProperties, StandardCharsets.UTF_8));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.isAvailable = false;
            }
            this.sortedReforgeKeys = this.reforgeTranslate.keySet().stream().map(Object::toString).sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
            this.sortedItemNameKeys = this.itemNameTranslate.keySet().stream().map(Object::toString).sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
        }

        public String translateItemName(String name) {
            String result;
            String string;
            if (name == null || !this.isAvailable || name.isEmpty()) {
                return name;
            }
            if (this.translationCache.containsKey(name)) {
                return this.translationCache.get(name);
            }
            String originalNameTemp = name;
            String nameTemp = null;
            for (String string2 : this.sortedItemNameKeys) {
                if (!(string2 instanceof String) || !originalNameTemp.contains(string2.toString())) continue;
                nameTemp = string2;
                originalNameTemp = originalNameTemp.replace(string2.toString(), "");
                break;
            }
            String reforgeTemp = null;
            for (String string3 : this.sortedReforgeKeys) {
                if (!(string3 instanceof String) || !originalNameTemp.contains(String.valueOf(string3) + " ")) continue;
                reforgeTemp = string3;
                break;
            }
            String string4 = string = reforgeTemp == null ? nameTemp : reforgeTemp + " " + nameTemp;
            if (nameTemp != null) {
                String string5 = reforgeTemp == null ? this.itemNameTranslate.getProperty(nameTemp) : this.reforgeTranslate.getProperty(reforgeTemp) + " " + this.itemNameTranslate.getProperty(nameTemp);
                result = name.replace(string, string5);
            } else {
                result = name;
            }
            this.translationCache.put(name, result);
            return result;
        }
    }
}

