/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.module.modules.macro;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.modules.player.NickHider;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.util.HaikuLogger;
import dev.greencat.shimmer.util.player.PlayerUtil;
import dev.greencat.shimmer.util.player.WalkerUtils;
import dev.greencat.shimmer.util.render.RenderUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1531;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;

public class AutoSlayer
extends Module {
    public final ModeSetting mode = new ModeSetting("Mob Type", "Choose the mob type you want to kill", "Zombie", "Zombie", "Wolf", "Spider");
    private final List<class_1309> blacklist = new ArrayList<class_1309>();
    private class_1309 prevTarget = null;
    private long lastSearch = 0L;
    private int count = 0;

    public AutoSlayer() {
        super("AutoSlayer", "Do slayer automatically", -1, Module.Category.MACRO);
        this.addSettings(this.mode);
        this.needDisable = true;
    }

    @ShimmerSubscribe
    public void onTick(TickEvent event) {
        if (AutoSlayer.mc.field_1724 == null || AutoSlayer.mc.field_1687 == null) {
            return;
        }
        if (this.count > 3) {
            this.blacklist.add(this.prevTarget);
        }
        ArrayList<class_1309> withInList = new ArrayList<class_1309>();
        for (class_1297 entity : AutoSlayer.mc.field_1687.method_18112()) {
            class_238 hitbox = entity.method_5829();
            if (!(entity instanceof class_1309) || !PlayerUtil.isWithin(class_3532.method_15350((double)AutoSlayer.mc.field_1724.method_23317(), (double)hitbox.field_1323, (double)hitbox.field_1320), class_3532.method_15350((double)AutoSlayer.mc.field_1724.method_23318(), (double)hitbox.field_1322, (double)hitbox.field_1325), class_3532.method_15350((double)AutoSlayer.mc.field_1724.method_23321(), (double)hitbox.field_1321, (double)hitbox.field_1324), 2.5) || !PlayerUtil.canSeeEntity(entity) || !this.checkMob((class_1309)entity)) continue;
            withInList.add((class_1309)entity);
        }
        if (withInList.isEmpty() && !WalkerUtils.isActive()) {
            class_1309 target = this.getNearestMob();
            if (target == null) {
                return;
            }
            if (this.prevTarget == null || !this.prevTarget.equals((Object)target)) {
                this.prevTarget = target;
                this.count = 0;
            }
            if (System.currentTimeMillis() - this.lastSearch >= 2000L) {
                this.lastSearch = System.currentTimeMillis();
                HaikuLogger.info(target.toString());
                if (AutoSlayer.mc.field_1687.method_8320(target.method_24515()).method_26204() instanceof class_2482 && AutoSlayer.mc.field_1687.method_8320(target.method_24515()).method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
                    WalkerUtils.walkTo(target.method_24515());
                } else {
                    WalkerUtils.walkTo(target.method_24515().method_10074());
                }
                ++this.count;
            }
        }
        if (!withInList.isEmpty() && WalkerUtils.isActive()) {
            WalkerUtils.cancel();
        }
        if (!withInList.isEmpty()) {
            this.lastSearch = System.currentTimeMillis() - 3000L;
        }
        Shimmer.getInstance().getModuleManager().getModule("Killaura").setEnabled(!withInList.isEmpty());
    }

    public boolean checkMob(class_1309 entity) {
        class_1309 livingEntity;
        if (entity.equals((Object)AutoSlayer.mc.field_1724) || entity.equals((Object)AutoSlayer.mc.field_1719)) {
            return false;
        }
        if (entity instanceof class_1309 && (livingEntity = entity).method_29504() || !entity.method_5805()) {
            return false;
        }
        if (entity.equals((Object)AutoSlayer.mc.field_1724) || entity.equals((Object)AutoSlayer.mc.field_1719)) {
            return false;
        }
        if (entity instanceof class_1309 && (livingEntity = entity).method_29504() || !entity.method_5805()) {
            return false;
        }
        if (entity instanceof class_1309 && (livingEntity = entity).method_5767() && !this.mode.equals("Ghost")) {
            return false;
        }
        if (entity instanceof class_1309 && !(livingEntity = entity).method_5805()) {
            return false;
        }
        if (entity instanceof class_1309 && !(livingEntity = entity).method_5732()) {
            return false;
        }
        if (entity instanceof class_1657) {
            return false;
        }
        if (this.blacklist.contains(entity)) {
            return false;
        }
        if (this.mode.equals("Zombie")) {
            return entity instanceof class_1642 && entity.method_23318() <= 70.0;
        }
        if (this.mode.equals("Wolf")) {
            return entity instanceof class_1493;
        }
        if (this.mode.equals("Spider")) {
            return entity instanceof class_1628;
        }
        return false;
    }

    public class_1309 getNearestMob() {
        ArrayList<class_1309> targetList = new ArrayList<class_1309>();
        for (Object entity : AutoSlayer.mc.field_1687.method_18112()) {
            class_1309 livingEntity;
            if (!(entity instanceof class_1309) || !this.checkMob(livingEntity = (class_1309)entity)) continue;
            targetList.add((class_1309)entity);
        }
        ArrayList<class_1531> signEntity = new ArrayList<class_1531>();
        for (class_1297 entity : AutoSlayer.mc.field_1687.method_18112()) {
            if (!(entity instanceof class_1531) || !entity.method_16914() || !entity.method_5797().getString().contains("Spawned by") || !entity.method_5797().getString().contains(class_310.method_1551().method_1548().method_1676()) && !entity.method_5797().getString().contains(NickHider.nickname.getString())) continue;
            signEntity.add((class_1531)entity);
        }
        ArrayList<class_1309> finalEntity = new ArrayList<class_1309>();
        if (!signEntity.isEmpty()) {
            for (class_1297 entity : AutoSlayer.mc.field_1687.method_18112()) {
                for (class_1531 sign : signEntity) {
                    if (!((double)entity.method_5739((class_1297)sign) < 2.5) || entity instanceof class_1657 || entity instanceof class_1531 || !(entity instanceof class_1309)) continue;
                    finalEntity.add((class_1309)entity);
                }
            }
        } else {
            finalEntity = targetList;
        }
        if (!signEntity.isEmpty() && finalEntity.isEmpty()) {
            finalEntity = targetList;
        }
        finalEntity.sort(Comparator.comparingDouble(PlayerUtil::squaredDistanceTo));
        return finalEntity.isEmpty() ? null : (class_1309)finalEntity.getFirst();
    }

    @ShimmerSubscribe
    public void onRender(RenderEvent.Post event) {
        if (AutoSlayer.mc.field_1687 == null || AutoSlayer.mc.field_1724 == null) {
            return;
        }
        for (class_1297 entity : AutoSlayer.mc.field_1687.method_18112()) {
            if (entity.method_5845().equals(AutoSlayer.mc.field_1724.method_5845()) || !(entity instanceof class_1531) || !entity.method_16914() || !entity.method_5797().getString().contains("Spawned by") || !entity.method_5797().getString().contains(class_310.method_1551().method_1548().method_1676()) && !entity.method_5797().getString().contains(NickHider.nickname.getString())) continue;
            RenderUtil.draw3DOutline(RenderUtil.smoothen(entity, entity.method_5829(), event.wrc.tickCounter().method_60637(false)), Color.GREEN, Objects.requireNonNull(event.wrc.matrixStack()), event.wrc);
            class_4184 camera = AutoSlayer.mc.field_1773.method_19418();
            class_243 start = new class_243(0.0, 0.0, 1.0).method_1037(-((float)Math.toRadians(camera.method_19329()))).method_1024(-((float)Math.toRadians(camera.method_19330())));
            class_243 end = RenderUtil.smoothen(entity, event.wrc.tickCounter().method_60637(false)).method_1031(0.0, (double)entity.method_5751(), 0.0);
            RenderUtil.draw3DLineFromPlayer(Objects.requireNonNull(event.wrc.matrixStack()), start, end, Color.GREEN, event.wrc);
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        WalkerUtils.cancel();
    }
}

