/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.command;

import dev.greencat.shimmer.command.Command;
import dev.greencat.shimmer.command.commands.BlockScannerTest;
import dev.greencat.shimmer.command.commands.HelpCmd;
import dev.greencat.shimmer.command.commands.ServerRotationTest;
import dev.greencat.shimmer.command.commands.ToggleCmd;
import dev.greencat.shimmer.command.commands.Travel;
import dev.greencat.shimmer.util.HaikuLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandManager {
    public String prefix = "-";
    public List<Command> commands = new ArrayList<Command>();
    boolean commandFound;

    public CommandManager() {
        this.commands.add(new HelpCmd());
        this.commands.add(new ToggleCmd());
        this.commands.add(new BlockScannerTest());
        this.commands.add(new ServerRotationTest());
        this.commands.add(new Travel());
    }

    public void execute(String command) {
        String message = command;
        if (!message.startsWith(this.prefix)) {
            return;
        }
        if ((message = message.substring(this.prefix.length())).split(" ").length > 0) {
            this.commandFound = false;
            String commandName = message.split(" ")[0];
            for (Command c2 : this.commands) {
                if (!c2.aliases.contains(commandName) && !c2.name.equalsIgnoreCase(commandName)) continue;
                c2.onCommand(Arrays.copyOfRange(message.split(" "), 1, message.split(" ").length), message);
                this.commandFound = true;
                break;
            }
            if (!this.commandFound) {
                HaikuLogger.error("Command not found, use " + this.prefix + "help");
            }
        }
    }

    public Command getCommand(String name) {
        for (Command command : this.commands) {
            if (!command.name.equalsIgnoreCase(name)) continue;
            return command;
        }
        return null;
    }
}

