/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockUtils;
import baritone.api.utils.accessor.IItemStack;
import baritone.api.utils.accessor.ILootTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public final class BlockOptionalMeta {
    private static final Pattern PATTERN = Pattern.compile("^(?<id>.+?)(?:\\[(?<properties>.+?)?\\])?$");
    private final dno block;
    private final String propertiesDescription;
    private final Set<ebq> blockstates;
    private final ImmutableSet<Integer> stateHashes;
    private final ImmutableSet<Integer> stackHashes;
    private static Map<dno, List<dag>> drops = new HashMap<dno, List<dag>>();
    private static Method getVanillaServerPack;

    public BlockOptionalMeta(@Nonnull dno dno2) {
        this.block = dno2;
        this.propertiesDescription = "{}";
        this.blockstates = BlockOptionalMeta.getStates(dno2, Collections.emptyMap());
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    public BlockOptionalMeta(@Nonnull String object) {
        object = PATTERN.matcher((CharSequence)object);
        if (!((Matcher)object).find()) {
            throw new IllegalArgumentException("invalid block selector");
        }
        this.block = BlockUtils.stringToBlockRequired(((Matcher)object).group("id"));
        Map map = (object = ((Matcher)object).group("properties")) == null || ((String)object).equals("") ? Collections.emptyMap() : BlockOptionalMeta.parseProperties(this.block, (String)object);
        this.propertiesDescription = object == null ? "{}" : "{" + ((String)object).replace("=", ":") + "}";
        this.blockstates = BlockOptionalMeta.getStates(this.block, map);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    private static <C extends Comparable<C>, P extends ect<C>> P castToIProperty(Object object) {
        return (P)((ect)object);
    }

    private static Map<ect<?>, ?> parseProperties(dno dno2, String stringArray) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string : stringArray.split(",")) {
            Object object = string.split("=");
            if (((String[])object).length != 2) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid property-value pair", string));
            }
            string = object[0];
            object = object[1];
            string = dno2.l().a(string);
            object = (Comparable)BlockOptionalMeta.castToIProperty(string).b((String)object).orElseThrow(() -> BlockOptionalMeta.lambda$parseProperties$0((String)object, (ect)string, dno2));
            builder.put((Object)string, object);
        }
        return builder.build();
    }

    private static Set<ebq> getStates(@Nonnull dno dno2, @Nonnull Map<ect<?>, ?> map) {
        return dno2.l().a().stream().filter(ebq2 -> map.entrySet().stream().allMatch(entry -> ebq2.c((ect)entry.getKey()) == entry.getValue())).collect(Collectors.toSet());
    }

    private static ImmutableSet<Integer> getStateHashes(Set<ebq> set) {
        return ImmutableSet.copyOf((Object[])((Integer[])set.stream().map(ebs::hashCode).toArray(Integer[]::new)));
    }

    private static ImmutableSet<Integer> getStackHashes(Set<ebq> set) {
        return ImmutableSet.copyOf((Object[])((Integer[])set.stream().flatMap(ebq2 -> BlockOptionalMeta.drops(ebq2.b()).stream().map(dag2 -> new dak((dki)dag2, 1))).map(dak2 -> ((IItemStack)dak2).getBaritoneHash()).toArray(Integer[]::new)));
    }

    public final dno getBlock() {
        return this.block;
    }

    public final boolean matches(@Nonnull dno dno2) {
        return dno2 == this.block;
    }

    public final boolean matches(@Nonnull ebq ebq2) {
        return ebq2.b() == this.block && this.stateHashes.contains((Object)ebq2.hashCode());
    }

    public final boolean matches(dak dak2) {
        int n2 = ((IItemStack)dak2).getBaritoneHash() - dak2.o();
        return this.stackHashes.contains((Object)n2);
    }

    public final String toString() {
        return String.format("BlockOptionalMeta{block=%s,properties=%s}", this.block, this.propertiesDescription);
    }

    public final ebq getAnyBlockState() {
        if (this.blockstates.size() > 0) {
            return this.blockstates.iterator().next();
        }
        return null;
    }

    public final Set<ebq> getAllBlockStates() {
        return this.blockstates;
    }

    public final Set<Integer> stackHashes() {
        return this.stackHashes;
    }

    private static aue getVanillaServerPack() {
        if (getVanillaServerPack == null) {
            getVanillaServerPack = Arrays.stream(avc.class.getDeclaredMethods()).filter(method -> method.getReturnType() == aue.class).findFirst().orElseThrow();
            getVanillaServerPack.setAccessible(true);
        }
        try {
            return (aue)getVanillaServerPack.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static synchronized List<dag> drops(dno dno2) {
        dno dno4 = dno2;
        return drops.computeIfAbsent(dno4, dno3 -> {
            if (dno3.u().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList arrayList = new ArrayList();
            try {
                ServerLevelStub serverLevelStub = ServerLevelStub.fastCreate();
                dno4 = new faw.a((asb)serverLevelStub).a(fdn.f, (Object)fgc.c).a(fdn.g, (Object)dno4.m()).a(fdn.i, (Object)new dak((dki)dao.qb, 1));
                BlockOptionalMeta.getDrops(dno3, (faw.a)dno4).stream().map(dak::h).forEach(arrayList::add);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        });
    }

    private static List<dak> getDrops(dno dno2, faw.a a2) {
        Optional optional = dno2.u();
        if (optional.isEmpty()) {
            return Collections.emptyList();
        }
        dno2 = a2.a(fdn.g, (Object)dno2.m()).a(fdm.r);
        return ((ILootTable)((ServerLevelStub)dno2.a()).holder().b((alq)optional.get())).invokeGetRandomItems(new fat.a((faw)dno2).a(1L).a(null));
    }

    private static /* synthetic */ IllegalArgumentException lambda$parseProperties$0(String string, ect ect2, dno dno2) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid value for %s on %s", string, ect2, dno2));
    }

    public static class ServerLevelStub
    extends asb {
        private static fqq client = fqq.Q();
        private static Unsafe unsafe = ServerLevelStub.getUnsafe();
        private static CompletableFuture<ju> registryAccess = ServerLevelStub.load();

        public ServerLevelStub(MinecraftServer minecraftServer, Executor executor, fah.c c2, fam fam2, alq<dkj> alq2, efo efo2, asl asl2, boolean bl2, long l2, List<djv> list, boolean bl3, @javax.annotation.Nullable bvh bvh2) {
            super(minecraftServer, executor, c2, fam2, alq2, efo2, asl2, bl2, l2, list, bl3, bvh2);
        }

        public cvs K() {
            assert (ServerLevelStub.client.s != null);
            return ServerLevelStub.client.s.K();
        }

        public static ServerLevelStub fastCreate() {
            try {
                return (ServerLevelStub)((Object)unsafe.allocateInstance(ServerLevelStub.class));
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
        }

        public ju J_() {
            return registryAccess.join();
        }

        public amb.a holder() {
            return new amb.a((ji.a)this.J_().e());
        }

        public static Unsafe getUnsafe() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public static CompletableFuture<ju> load() {
            avh avh2 = new avh(auc.b, List.of(avc.b()));
            jn jn2 = ama.a();
            List list = ayd.a((avo)avh2, (ju)jn2.a((Object)ama.a));
            List list2 = ayd.a((ju.b)jn2.b((Object)ama.b), (List)list);
            return amb.a((jn)jn2.a((Object)ama.b, new ju.b[]{alm.a((avo)avh2, (List)list2, (List)alm.a)}), (List)list, (avo)avh2, (Executor)fqq.Q()).thenApply(b2 -> b2.a().a());
        }

        public /* synthetic */ edr S() {
            return super.m();
        }

        public /* synthetic */ edn a(int n2, int n3) {
            return super.d(n2, n3);
        }

        public /* synthetic */ fhq T() {
            return super.o();
        }

        public /* synthetic */ fhq U() {
            return super.n();
        }

        public /* synthetic */ dfc Q() {
            return super.t();
        }

        public /* synthetic */ fhh R() {
            return super.g();
        }

        @Nullable
        public /* synthetic */ egj c(UUID uUID) {
            return super.b(uUID);
        }
    }
}

