/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.module.modules.misc;

import dev.greencat.shimmer.event.events.LivingEntityRenderPreEvent;
import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5251;

public class DamageSplash
extends Module {
    public final BooleanSetting damageSplashCompact = new BooleanSetting("Damage Splash Compact", "Compact your damage number,example:1,500,000 to 1.5M", false);
    public final NumberSetting damageSplashOffset = new NumberSetting("Damage Splash Offset", "Move you damage splash randomly", 2.0, 0.0, 5.0, 0.01);
    public final NumberSetting damageSplashAnimationSpeed = new NumberSetting("Damage Splash Animation Speed", "Change the spawn speed", 0.3, 0.0, 2.0, 0.01);
    public final NumberSetting damageSplashDuration = new NumberSetting("Damage Splash Duration", "Change the duration", 3.0, 0.0, 10.0, 0.01);
    public final BooleanSetting damageSplashCombine = new BooleanSetting("Damage Splash Combine", "Combine nearly splash text", true);
    private static final Pattern pattern = Pattern.compile("[\u2727\u272f]?(\\d{1,3}(?:,\\d{3})*[\u2694+\u2727\u2764\u265e\u2604\u2737\ufb17\u272f]*)");
    private static final Deque<RenderInformation> damages = new LinkedList<RenderInformation>();
    private static final List<class_1309> removeList = new LinkedList<class_1309>();
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private static final Random random = new Random();

    public DamageSplash() {
        super("DamageSplash", "Make your damage splash better", -1, Module.Category.MISC);
        this.addSettings(this.damageSplashCompact, this.damageSplashOffset, this.damageSplashAnimationSpeed, this.damageSplashDuration, this.damageSplashCombine);
    }

    @ShimmerSubscribe
    public boolean onRenderEntity(LivingEntityRenderPreEvent event) {
        String string;
        Matcher matcher;
        for (class_1297 class_12972 : removeList) {
            if (class_310.method_1551().field_1687 == null) continue;
            class_310.method_1551().field_1687.method_2945(class_12972.method_5628(), class_1297.class_5529.field_27001);
        }
        removeList.clear();
        class_1309 entity = event.entity;
        if (entity instanceof class_1531 && entity.method_16914() && (matcher = pattern.matcher((string = entity.method_5797().getString()) == null ? "" : string)).matches() && string != null) {
            Object damage = string.replaceAll("[^\\d]", "");
            long damageInteger = Long.parseLong((String)damage);
            if (this.damageSplashCompact.isEnabled()) {
                try {
                    if (damageInteger >= 1000L && damageInteger < 1000000L) {
                        damageDouble = (double)damageInteger / 1000.0;
                        damage = decimalFormat.format(damageDouble) + "K";
                    } else if (damageInteger >= 1000000L && damageInteger < 1000000000L) {
                        damageDouble = (double)damageInteger / 1000000.0;
                        damage = decimalFormat.format(damageDouble) + "M";
                    } else if (damageInteger >= 1000000000L) {
                        damageDouble = (double)damageInteger / 1.0E9;
                        damage = decimalFormat.format(damageDouble) + "B";
                    }
                }
                catch (Exception damageDouble) {
                    // empty catch block
                }
            }
            RenderInformation info = new RenderInformation(entity.method_23317() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0) - this.damageSplashOffset.getValue(), entity.method_23318() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0) - this.damageSplashOffset.getValue(), entity.method_23321() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0) - this.damageSplashOffset.getValue(), (String)damage, new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255)), damageInteger);
            boolean combined = false;
            if (this.damageSplashCombine.isEnabled()) {
                for (RenderInformation entry : damages) {
                    if (!(Math.sqrt((info.x - entry.x) * (info.x - entry.x) + (info.y - entry.y) * (info.y - entry.y) + (info.z - entry.z)) <= 1.75 + this.damageSplashOffset.getValue())) continue;
                    combined = true;
                    entry.startTime = (long)((double)System.currentTimeMillis() - this.damageSplashAnimationSpeed.getValue() * 1000.0);
                    entry.damage += damageInteger;
                    Object dmgStr = String.valueOf(entry.damage);
                    if (this.damageSplashCompact.isEnabled()) {
                        try {
                            if (entry.damage >= 1000L && entry.damage < 1000000L) {
                                double damageDouble = (double)entry.damage / 1000.0;
                                dmgStr = decimalFormat.format(damageDouble) + "K";
                            } else if (entry.damage >= 1000000L && entry.damage < 1000000000L) {
                                double damageDouble = (double)entry.damage / 1000000.0;
                                dmgStr = decimalFormat.format(damageDouble) + "M";
                            } else if (entry.damage >= 1000000000L) {
                                double damageDouble = (double)entry.damage / 1.0E9;
                                dmgStr = decimalFormat.format(damageDouble) + "B";
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    entry.message = dmgStr;
                    break;
                }
            }
            if (!combined) {
                damages.add(info);
            }
            removeList.add(entity);
            return false;
        }
        return true;
    }

    @ShimmerSubscribe
    public void onRenderWorld(RenderEvent.Post event) {
        if (class_310.method_1551().field_1724 == null) {
            damages.clear();
            return;
        }
        WorldRenderContext wrc = event.wrc;
        ArrayList<RenderInformation> removeList = new ArrayList<RenderInformation>();
        for (RenderInformation info : damages) {
            class_243 pos = new class_243(info.x, info.y, info.z);
            float scaling = (float)Math.max(2.0, Math.log(pos.method_1022(class_310.method_1551().field_1724.method_19538()) * 3.0));
            TextRenderUtil.renderText(wrc, (class_2561)class_2561.method_43470((String)info.message).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)info.color.getRGB()))), pos, (float)((double)(System.currentTimeMillis() - info.startTime) <= this.damageSplashAnimationSpeed.getValue() * 1000.0 ? (double)(System.currentTimeMillis() - info.startTime) / (this.damageSplashAnimationSpeed.getValue() * 1000.0) * (double)scaling : (double)scaling), true, wrc.consumers());
            if (!((double)(System.currentTimeMillis() - info.startTime) >= this.damageSplashDuration.getValue() * 1000.0)) continue;
            removeList.add(info);
        }
        if (!removeList.isEmpty()) {
            damages.removeAll(removeList);
        }
    }

    static class RenderInformation {
        double x;
        double y;
        double z;
        String message;
        Color color;
        long startTime;
        long damage;

        public RenderInformation(double x2, double y2, double z2, String message, Color color, long damage) {
            this.x = x2;
            this.y = y2;
            this.z = z2;
            this.message = message;
            this.startTime = System.currentTimeMillis();
            this.color = color;
            this.damage = damage;
        }
    }
}

