/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.util.render.animation;

import dev.greencat.shimmer.util.render.animation.AnimationEngine;
import dev.greencat.shimmer.util.render.animation.AnimationManager;
import java.util.LinkedList;
import java.util.Queue;

public class QueueAnimationEngine
extends AnimationEngine {
    public Queue<PositionWrapper> animationQueue = new LinkedList<PositionWrapper>();

    public QueueAnimationEngine() {
    }

    public QueueAnimationEngine(int x2, int y2) {
        super(x2, y2);
    }

    public boolean isWorking() {
        return AnimationManager.animations.containsKey(this);
    }

    public void QueueMoveTo(int x2, int y2, double second, int type) {
        if (!this.isWorking()) {
            super.moveTo(x2, y2, second, type);
        } else {
            this.animationQueue.offer(new PositionWrapper(x2, y2, second, type));
        }
    }

    @Override
    public void callback() {
        if (!this.isWorking() && !this.animationQueue.isEmpty()) {
            PositionWrapper positionWrapper = this.animationQueue.poll();
            super.moveTo(positionWrapper.x, positionWrapper.y, positionWrapper.speed, positionWrapper.type);
        }
    }

    static class PositionWrapper {
        public int x;
        public int y;
        public double speed;
        public int type;

        public PositionWrapper(int x2, int y2, double speed, int type) {
            this.x = x2;
            this.y = y2;
            this.speed = speed;
            this.type = type;
        }
    }
}

