/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.module.modules.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.RenderInGameHudEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.modules.misc.RainTimer;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.util.render.Rect;
import dev.greencat.shimmer.util.render.Shadow;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import dev.greencat.shimmer.util.render.animation.AnimationEngine;
import dev.greencat.shimmer.util.world.TPSUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_5348;

public class Hud
extends Module {
    public final BooleanSetting arraylist = new BooleanSetting("Arraylist", "Renders the Shimmer arraylist.", true);
    public final BooleanSetting ticks = new BooleanSetting("TPS", "Renders the ticks per second.", true);
    public final BooleanSetting fps = new BooleanSetting("FPS", "Renders the frames per second.", true);
    private final AnimationEngine rectAnimation = new AnimationEngine(0, 0);
    private long colorCounter = 0L;
    private long colorDelay = 0L;
    private final AnimationEngine normalInformationAnimation = new AnimationEngine(0, 0);
    private final int arrayListColor = new Color(0, 0, 0, 120).getRGB();
    private final Color centerHUDColor = new Color(0, 0, 0, 120);
    private static CopyOnWriteArrayList<class_2561> noticeList = new CopyOnWriteArrayList();
    private static long lastMesaage = 0L;
    private static int arrayListHeight = 0;

    public Hud() {
        super("HUD", "Renders the Shimmer hud.", -1, Module.Category.RENDER);
        this.addSettings(this.arraylist, this.ticks, this.fps);
    }

    @Override
    public void onEnable() {
        super.onEnable();
    }

    public static void onMessage(class_2561 ... texts) {
        noticeList.clear();
        Collections.addAll(noticeList, texts);
        lastMesaage = System.currentTimeMillis();
    }

    public AnimationEngine getRectAnimation() {
        return this.rectAnimation;
    }

    public int getArrayListHeight() {
        return arrayListHeight;
    }

    @ShimmerSubscribe
    public void onRender(RenderInGameHudEvent event) {
        int longest;
        if (Hud.mc.field_1687 == null || Hud.mc.field_1724 == null) {
            return;
        }
        if (mc.method_53526().method_53536()) {
            return;
        }
        if (!Shimmer.getInstance().isSorted) {
            Shimmer.getInstance().isSorted = true;
            Shimmer.getInstance().getModuleManager().refreshEnabled();
        }
        int screenWidth = mc.method_22683().method_4486();
        String tpsInfo = "TPS: " + TPSUtil.INSTANCE.getTPS();
        String fpsInfo = Hud.mc.field_1770.split(" ")[0];
        String fpsString = "FPS:" + fpsInfo;
        int rectX = Math.max(screenWidth / 10, Hud.mc.field_1772.method_1727("Shimmer |") + (this.fps.isEnabled() ? Hud.mc.field_1772.method_1727(fpsString) + 5 : 0) + (this.ticks.isEnabled() ? Hud.mc.field_1772.method_1727(tpsInfo) + 5 : 0) + 20);
        int rectY = 14 + (Shimmer.getInstance().getModuleManager().getModule("RainTimer").isEnabled() ? 14 : 0);
        if (System.currentTimeMillis() - lastMesaage <= 1200L && !noticeList.isEmpty()) {
            longest = 0;
            for (class_2561 text : noticeList) {
                int length = Hud.mc.field_1772.method_27525((class_5348)text);
                if (length <= longest) continue;
                longest = length;
            }
            rectX = longest + 20;
            rectY = noticeList.size() * 12 + 2;
            this.normalInformationAnimation.moveTo(0.0f, -12 + (Shimmer.getInstance().getModuleManager().getModule("RainTimer").isEnabled() ? -14 : 0), 0.3, 1);
        } else if (!noticeList.isEmpty()) {
            noticeList.clear();
        }
        if (this.rectAnimation.xCoord == 0.0 && this.rectAnimation.yCoord == 0.0) {
            this.rectAnimation.xCoord = rectX;
            this.rectAnimation.yCoord = rectY;
        }
        this.rectAnimation.moveTo(rectX, rectY, 0.3, 1);
        event.getContext().method_51448().method_22903();
        GlStateManager._enableBlend();
        Rect.draw2DRoundedRect((float)((double)((float)screenWidth / 2.0f) - this.rectAnimation.xCoord / 2.0), 3.0f, (float)this.rectAnimation.xCoord, (float)this.rectAnimation.yCoord, (float)(this.rectAnimation.yCoord / 2.0), 0.0f, this.centerHUDColor, event.getContext());
        event.getContext().method_51448().method_22909();
        if (System.currentTimeMillis() - lastMesaage > 1220L && System.currentTimeMillis() - lastMesaage < 1550L) {
            longest = Math.max(Math.max(Hud.mc.field_1772.method_1727("Shimmer |"), Hud.mc.field_1772.method_1727(fpsString)), Hud.mc.field_1772.method_1727(tpsInfo)) + 20;
            this.rectAnimation.moveTo(longest, rectY, 0.3, 1);
        }
        if (System.currentTimeMillis() - lastMesaage > 1800L) {
            this.normalInformationAnimation.moveTo(0.0f, 6.0f, 0.3, 1);
        } else if (!noticeList.isEmpty()) {
            int i2 = 0;
            for (class_2561 text : noticeList) {
                event.getContext().method_25303(Hud.mc.field_1772, text.getString(), screenWidth / 2 - Hud.mc.field_1772.method_27525((class_5348)text) / 2, 6 + i2 * 11, 0xFFFFFF);
                ++i2;
            }
            TextRenderUtil.cleanIndex();
        }
        event.getContext().method_25303(Hud.mc.field_1772, "Shimmer |", System.currentTimeMillis() - lastMesaage <= 1200L ? screenWidth / 2 - Hud.mc.field_1772.method_1727("Shimmer |") / 2 : screenWidth / 2 - (int)this.rectAnimation.xCoord / 2 + 10, (int)this.normalInformationAnimation.yCoord, 0xFFFFFF);
        if (this.fps.isEnabled()) {
            event.getContext().method_25303(Hud.mc.field_1772, fpsString, System.currentTimeMillis() - lastMesaage <= 1200L ? screenWidth / 2 - Hud.mc.field_1772.method_1727("Shimmer |") / 2 : screenWidth / 2 - (int)this.rectAnimation.xCoord / 2 + 15 + Hud.mc.field_1772.method_1727("Shimmer |"), (int)this.normalInformationAnimation.yCoord, 0xFFFFFF);
        }
        if (this.ticks.isEnabled()) {
            event.getContext().method_25303(Hud.mc.field_1772, tpsInfo, System.currentTimeMillis() - lastMesaage <= 1200L ? screenWidth / 2 - Hud.mc.field_1772.method_1727("Shimmer |") / 2 : screenWidth / 2 - (int)this.rectAnimation.xCoord / 2 + 15 + Hud.mc.field_1772.method_1727("Shimmer |") + (this.fps.isEnabled() ? Hud.mc.field_1772.method_1727(fpsString) + 5 : 0), (int)this.normalInformationAnimation.yCoord, 0xFFFFFF);
        }
        if (Shimmer.getInstance().getModuleManager().getModule("RainTimer").isEnabled()) {
            class_2561 rain = RainTimer.getStringForRenderAndUpdate();
            event.getContext().method_27535(Hud.mc.field_1772, rain, screenWidth / 2 - Hud.mc.field_1772.method_27525((class_5348)rain) / 2, (int)this.normalInformationAnimation.yCoord + 12, 0xFFFFFF);
        }
        if (System.currentTimeMillis() - this.colorDelay >= 30L) {
            this.colorDelay = System.currentTimeMillis();
            ++this.colorCounter;
        }
        int y2 = 2;
        int lastWidth = Hud.mc.field_1772.method_1727(Shimmer.getInstance().getModuleManager().enabledModules.getFirst()) + 8;
        arrayListHeight = 0;
        if (this.arraylist.isEnabled()) {
            for (String str : Shimmer.getInstance().getModuleManager().enabledModules) {
                boolean swap = (int)((float)((long)y2 + this.colorCounter) / 3.0f / 30.0f) % 2 == 0;
                Color currentColor = Color.getHSBColor(0.925f, ((swap ? 30.0f - (float)((long)y2 + this.colorCounter) / 3.0f % 30.0f : (float)((long)y2 + this.colorCounter) / 3.0f % 30.0f) + 35.0f) / 100.0f, 1.0f);
                event.getContext().method_25294(screenWidth - Hud.mc.field_1772.method_1727(str) - 3 - 5, y2 - 2, screenWidth, y2 + 10, this.arrayListColor);
                event.getContext().method_25294(screenWidth - 3, y2 - 2, screenWidth, y2 + 10, currentColor.getRGB());
                int widthDiffer = lastWidth - Hud.mc.field_1772.method_1727(str) - 8;
                Shadow.drawShadow(screenWidth - Hud.mc.field_1772.method_1727(str) - 3 - 5 - widthDiffer, y2 - 14, widthDiffer, 12, event.getContext(), Shadow.ShadowLocation.BOTTOM);
                Shadow.drawShadow(screenWidth - Hud.mc.field_1772.method_1727(str) - 3 - 5, y2 - 2, 0, 12, event.getContext(), Shadow.ShadowLocation.LEFT);
                Shadow.drawShadow(screenWidth - Hud.mc.field_1772.method_1727(str) - 3 - 5, y2 - 2, 0, 12, event.getContext(), Shadow.ShadowLocation.BOTTOM_LEFT);
                event.getContext().method_25303(Hud.mc.field_1772, str, screenWidth - Hud.mc.field_1772.method_1727(str) - 5, y2, currentColor.getRGB());
                lastWidth = Hud.mc.field_1772.method_1727(str) + 8;
                y2 += 12;
            }
        }
        arrayListHeight = y2 - 2;
        Shadow.drawShadow(screenWidth - lastWidth, y2 - 14, lastWidth, 12, event.getContext(), Shadow.ShadowLocation.BOTTOM);
    }
}

