/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.VecUtils;
import java.util.Optional;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final float DEG_TO_RAD_F = (float)Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final float RAD_TO_DEG_F = 57.29578f;
    private static final fgc[] BLOCK_SIDE_MULTIPLIERS = new fgc[]{new fgc(0.5, 0.0, 0.5), new fgc(0.5, 1.0, 0.5), new fgc(0.5, 0.5, 0.0), new fgc(0.5, 0.5, 1.0), new fgc(0.0, 0.5, 0.5), new fgc(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(iw iw2, iw iw3) {
        return RotationUtils.calcRotationFromVec3d(new fgc((double)iw2.u(), (double)iw2.v(), (double)iw2.w()), new fgc((double)iw3.u(), (double)iw3.v(), (double)iw3.w()));
    }

    public static Rotation wrapAnglesToRelative(Rotation rotation, Rotation rotation2) {
        if (rotation.yawIsReallyClose(rotation2)) {
            return new Rotation(rotation.getYaw(), rotation2.getPitch());
        }
        return rotation2.subtract(rotation).normalize().add(rotation);
    }

    public static Rotation calcRotationFromVec3d(fgc fgc2, fgc fgc3, Rotation rotation) {
        return RotationUtils.wrapAnglesToRelative(rotation, RotationUtils.calcRotationFromVec3d(fgc2, fgc3));
    }

    private static Rotation calcRotationFromVec3d(fgc object, fgc fgc2) {
        double[] dArray = new double[]{object.d - fgc2.d, object.e - fgc2.e, object.f - fgc2.f};
        object = dArray;
        double d2 = azz.d((double)dArray[0], (double)(-object[2]));
        double d3 = Math.sqrt((double)(object[0] * object[0] + object[2] * object[2]));
        double d4 = azz.d((double)object[1], (double)d3);
        return new Rotation((float)(d2 * 57.29577951308232), (float)(d4 * 57.29577951308232));
    }

    public static fgc calcLookDirectionFromRotation(Rotation rotation) {
        float f2 = azz.b((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = azz.a((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -azz.b((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f5 = azz.a((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new fgc((double)(f3 * f4), (double)f5, (double)(f2 * f4));
    }

    @Deprecated
    public static fgc calcVec3dFromRotation(Rotation rotation) {
        return RotationUtils.calcLookDirectionFromRotation(rotation);
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, iw iw2) {
        return RotationUtils.reachable(iPlayerContext, iw2, false);
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, iw iw2, boolean bl2) {
        return RotationUtils.reachable(iPlayerContext, iw2, iPlayerContext.playerController().getBlockReachDistance(), bl2);
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, iw iw2, double d2) {
        return RotationUtils.reachable(iPlayerContext, iw2, d2, false);
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, iw iw2, double d2, boolean bl2) {
        fgw fgw2;
        Optional<Rotation> optional;
        if (((Boolean)BaritoneAPI.getSettings().remainWithExistingLookDirection.value).booleanValue() && iPlayerContext.isLookingAt(iw2)) {
            optional = iPlayerContext.playerRotations().add(new Rotation(0.0f, 1.0E-4f));
            if (bl2) {
                fgw2 = RayTraceUtils.rayTraceTowards((bxe)iPlayerContext.player(), (Rotation)((Object)optional), d2, true);
                if (fgw2 != null && fgw2.d() == fga.a.b && ((ffy)fgw2).b().equals((Object)iw2)) {
                    return Optional.of(optional);
                }
            } else {
                return Optional.of(optional);
            }
        }
        if ((optional = RotationUtils.reachableCenter(iPlayerContext, iw2, d2, bl2)).isPresent()) {
            return optional;
        }
        fgw2 = iPlayerContext.world().a_(iw2).f((djn)iPlayerContext.world(), iw2);
        if (fgw2.c()) {
            fgw2 = fgt.b();
        }
        fgc[] fgcArray = BLOCK_SIDE_MULTIPLIERS;
        int n2 = BLOCK_SIDE_MULTIPLIERS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            optional = fgcArray[i2];
            double d3 = fgw2.b(jc.a.a) * ((fgc)optional).d + fgw2.c(jc.a.a) * (1.0 - ((fgc)optional).d);
            double d4 = fgw2.b(jc.a.b) * ((fgc)optional).e + fgw2.c(jc.a.b) * (1.0 - ((fgc)optional).e);
            double d5 = fgw2.b(jc.a.c) * ((fgc)optional).f + fgw2.c(jc.a.c) * (1.0 - ((fgc)optional).f);
            optional = RotationUtils.reachableOffset(iPlayerContext, iw2, new fgc((double)iw2.u(), (double)iw2.v(), (double)iw2.w()).b(d3, d4, d5), d2, bl2);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(IPlayerContext iPlayerContext, iw iw2, fgc object, double d2, boolean bl2) {
        object = RotationUtils.calcRotationFromVec3d(bl2 ? RayTraceUtils.inferSneakingEyePosition((bxe)iPlayerContext.player()) : iPlayerContext.player().n(1.0f), object, iPlayerContext.playerRotations());
        Rotation rotation = BaritoneAPI.getProvider().getBaritoneForPlayer(iPlayerContext.player()).getLookBehavior().getAimProcessor().peekRotation((Rotation)object);
        fga fga2 = RayTraceUtils.rayTraceTowards((bxe)iPlayerContext.player(), rotation, d2, bl2);
        if (fga2 != null && fga2.d() == fga.a.b) {
            if (((ffy)fga2).b().equals((Object)iw2)) {
                return Optional.of(object);
            }
            if (iPlayerContext.world().a_(iw2).b() instanceof dnb && ((ffy)fga2).b().equals((Object)iw2.e())) {
                return Optional.of(object);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(IPlayerContext iPlayerContext, iw iw2, double d2, boolean bl2) {
        return RotationUtils.reachableOffset(iPlayerContext, iw2, VecUtils.calculateBlockCenter(iPlayerContext.world(), iw2), d2, bl2);
    }

    @Deprecated
    public static Optional<Rotation> reachable(gqm gqm2, iw iw2, double d2) {
        return RotationUtils.reachable(gqm2, iw2, d2, false);
    }

    @Deprecated
    public static Optional<Rotation> reachable(gqm gqm2, iw iw2, double d2, boolean bl2) {
        return RotationUtils.reachable(BaritoneAPI.getProvider().getBaritoneForPlayer(gqm2).getPlayerContext(), iw2, d2, bl2);
    }

    @Deprecated
    public static Optional<Rotation> reachableOffset(bxe bxe2, iw iw2, fgc object, double d2, boolean bl2) {
        object = RotationUtils.calcRotationFromVec3d(bl2 ? RayTraceUtils.inferSneakingEyePosition(bxe2) : bxe2.n(1.0f), object, new Rotation(bxe2.dL(), bxe2.dN()));
        fga fga2 = RayTraceUtils.rayTraceTowards(bxe2, (Rotation)object, d2, bl2);
        if (fga2 != null && fga2.d() == fga.a.b) {
            if (((ffy)fga2).b().equals((Object)iw2)) {
                return Optional.of(object);
            }
            if (bxe2.dV().a_(iw2).b() instanceof dnb && ((ffy)fga2).b().equals((Object)iw2.e())) {
                return Optional.of(object);
            }
        }
        return Optional.empty();
    }

    @Deprecated
    public static Optional<Rotation> reachableCenter(bxe bxe2, iw iw2, double d2, boolean bl2) {
        return RotationUtils.reachableOffset(bxe2, iw2, VecUtils.calculateBlockCenter(bxe2.dV(), iw2), d2, bl2);
    }
}

