/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockOptionalMeta;
import baritone.api.utils.accessor.IItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;

public class BlockOptionalMetaLookup {
    private final ImmutableSet<dno> blockSet;
    private final ImmutableSet<ebq> blockStateSet;
    private final ImmutableSet<Integer> stackHashes;
    private final BlockOptionalMeta[] boms;

    public BlockOptionalMetaLookup(BlockOptionalMeta ... blockOptionalMetaArray) {
        this.boms = blockOptionalMetaArray;
        HashSet<dno> hashSet = new HashSet<dno>();
        HashSet<ebq> hashSet2 = new HashSet<ebq>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        for (BlockOptionalMeta blockOptionalMeta : blockOptionalMetaArray) {
            hashSet.add(blockOptionalMeta.getBlock());
            hashSet2.addAll(blockOptionalMeta.getAllBlockStates());
            hashSet3.addAll(blockOptionalMeta.stackHashes());
        }
        this.blockSet = ImmutableSet.copyOf(hashSet);
        this.blockStateSet = ImmutableSet.copyOf(hashSet2);
        this.stackHashes = ImmutableSet.copyOf(hashSet3);
    }

    public BlockOptionalMetaLookup(dno ... dnoArray) {
        this((BlockOptionalMeta[])Stream.of(dnoArray).map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new));
    }

    public BlockOptionalMetaLookup(List<dno> list) {
        this((BlockOptionalMeta[])list.stream().map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new));
    }

    public BlockOptionalMetaLookup(String ... stringArray) {
        this((BlockOptionalMeta[])Stream.of(stringArray).map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new));
    }

    public boolean has(dno dno2) {
        return this.blockSet.contains((Object)dno2);
    }

    public boolean has(ebq ebq2) {
        return this.blockStateSet.contains((Object)ebq2);
    }

    public boolean has(dak dak2) {
        int n2 = ((IItemStack)dak2).getBaritoneHash() - dak2.o();
        return this.stackHashes.contains((Object)n2);
    }

    public List<BlockOptionalMeta> blocks() {
        return Arrays.asList(this.boms);
    }

    public String toString() {
        return String.format("BlockOptionalMetaLookup{%s}", Arrays.toString(this.boms));
    }
}

