/*
 * Decompiled with CFR 0.152.
 */
package dev.greencat.shimmer.util.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.greencat.shimmer.mixin.DrawContextAccessor;
import dev.greencat.shimmer.util.render.ShimmerRenderLayer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_9974;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static final class_310 mc = class_310.method_1551();

    public static void draw3DBox(class_238 boxO, Color color, class_4587 stack, WorldRenderContext context) {
        class_238 box = new class_238(boxO.field_1323, boxO.field_1322, boxO.field_1321, boxO.field_1320, boxO.field_1325, boxO.field_1324);
        class_4184 camera = RenderUtil.mc.field_1773.method_19418();
        stack.method_22903();
        stack.method_22904(-camera.method_19326().method_10216(), -camera.method_19326().method_10214(), -camera.method_19326().method_10215());
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = ShimmerRenderLayer.getLinesThroughWalls(10.0);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        RenderUtil.setup3D();
        for (double i2 = 0.0; i2 <= box.field_1320 - box.field_1323; i2 += 0.1) {
            for (double j2 = 0.0; j2 <= box.field_1325 - box.field_1322; j2 += 0.1) {
                class_9974.method_62292((class_4587)stack, (class_4588)buffer, (double)((box.field_1323 + box.field_1320 - i2) / 2.0), (double)((box.field_1322 + box.field_1325 - j2) / 2.0), (double)box.field_1321, (double)((box.field_1323 + box.field_1320 + i2) / 2.0), (double)((box.field_1322 + box.field_1325 + j2) / 2.0), (double)box.field_1324, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            }
        }
        consumers.method_22993();
        RenderUtil.clean3D();
        stack.method_22909();
    }

    public static void draw3DOutline(class_238 box, Color color, class_4587 stack, WorldRenderContext context) {
        class_4184 camera = RenderUtil.mc.field_1773.method_19418();
        stack.method_22903();
        stack.method_22904(-camera.method_19326().method_10216(), -camera.method_19326().method_10214(), -camera.method_19326().method_10215());
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = ShimmerRenderLayer.getLines(8.0);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        RenderUtil.setup3D();
        class_9974.method_62292((class_4587)stack, (class_4588)buffer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        consumers.method_22993();
        RenderUtil.clean3D();
        stack.method_22909();
    }

    public static void draw2DOutline(class_238 box, Color color, class_4587 stack, WorldRenderContext context) {
        class_4184 c2 = RenderUtil.mc.field_1773.method_19418();
        class_243 camPos = c2.method_19326();
        class_243 start = box.method_1005().method_1020(camPos);
        float x2 = (float)start.field_1352;
        float y2 = (float)start.field_1351;
        float z2 = (float)start.field_1350;
        double r2 = Math.toRadians(-c2.method_19330() + 90.0f);
        double length = Math.sqrt((box.field_1320 - box.field_1323) * (box.field_1320 - box.field_1323) * (box.field_1324 - box.field_1321) * (box.field_1324 - box.field_1321)) / 1.5;
        float sin = (float)(Math.sin(r2) * length);
        float cos = (float)(Math.cos(r2) * length);
        stack.method_22903();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921 layer = class_1921.method_49043((double)8.0);
        class_4588 buffer = consumers.getBuffer(layer);
        GL11.glDepthFunc((int)519);
        GlStateManager._enableBlend();
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2, z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2, z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, (float)((double)y2 + (box.field_1325 - box.field_1322)), z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2 + (float)((double)y2 + (box.field_1325 - box.field_1322)), z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2 + (float)((double)y2 + (box.field_1325 - box.field_1322)), z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2 + (float)((double)y2 + (box.field_1325 - box.field_1322)), z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        consumers.method_22993();
        GL11.glDepthFunc((int)515);
        GlStateManager._disableBlend();
        stack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void draw2DOutline(class_1297 entity, Color color, class_4587 stack, WorldRenderContext context) {
        class_4184 c2 = RenderUtil.mc.field_1773.method_19418();
        class_243 camPos = c2.method_19326();
        class_243 start = entity.method_19538().method_1020(camPos);
        float x2 = (float)start.field_1352;
        float y2 = (float)start.field_1351;
        float z2 = (float)start.field_1350;
        double r2 = Math.toRadians(-c2.method_19330() + 90.0f);
        float sin = (float)(Math.sin(r2) * ((double)entity.method_17681() / 1.5));
        float cos = (float)(Math.cos(r2) * ((double)entity.method_17681() / 1.5));
        stack.method_22903();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921 layer = class_1921.method_49043((double)8.0);
        class_4588 buffer = consumers.getBuffer(layer);
        GL11.glDepthFunc((int)519);
        GlStateManager._enableBlend();
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2, z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2, z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2 + entity.method_17682(), z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2 + entity.method_17682(), z2 - cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2 + entity.method_17682(), z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2 + entity.method_17682(), z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        consumers.method_22993();
        GL11.glDepthFunc((int)515);
        GlStateManager._disableBlend();
        stack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void draw2DOutlinePlayer(class_1297 entity, Color color, class_4587 stack, WorldRenderContext context) {
        class_4184 c2 = RenderUtil.mc.field_1773.method_19418();
        class_243 camPos = c2.method_19326();
        class_243 start = entity.method_19538().method_1020(camPos);
        float x2 = (float)start.field_1352;
        float y2 = (float)start.field_1351;
        float z2 = (float)start.field_1350;
        double r2 = Math.toRadians(-c2.method_19330() + 90.0f);
        float sin = (float)(Math.sin(r2) * ((double)entity.method_17681() / 1.5));
        float cos = (float)(Math.cos(r2) * ((double)entity.method_17681() / 1.5));
        stack.method_22903();
        class_2960 texture = class_2960.method_60654((String)"shimmer:player_box.png");
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921 layer = class_1921.method_62276((class_2960)texture);
        class_4588 buffer = consumers.getBuffer(layer);
        GL11.glDepthFunc((int)519);
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        GlStateManager._enableBlend();
        buffer.method_56824(stack.method_23760(), x2 + sin, y2, z2 + cos).method_22913(0.0f, 0.0f).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2, z2 - cos).method_22913(0.0f, 1.0f).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 - sin, y2 + entity.method_17682(), z2 - cos).method_22913(1.0f, 1.0f).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(stack.method_23760(), x2 + sin, y2 + entity.method_17682(), z2 + cos).method_22913(1.0f, 0.0f).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        consumers.method_22993();
        GL11.glDepthFunc((int)515);
        GlStateManager._disableBlend();
        stack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void draw3DLine(class_4587 matrixStack, class_243 start, class_243 end, Color color, WorldRenderContext context) {
        class_4184 camera = RenderUtil.mc.field_1773.method_19418();
        float startX = (float)(start.field_1352 - camera.method_19326().field_1352);
        float startY = (float)(start.field_1351 - camera.method_19326().field_1351);
        float startZ = (float)(start.field_1350 - camera.method_19326().field_1350);
        float endX = (float)(end.field_1352 - camera.method_19326().field_1352);
        float endY = (float)(end.field_1351 - camera.method_19326().field_1351);
        float endZ = (float)(end.field_1350 - camera.method_19326().field_1350);
        matrixStack.method_22903();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = ShimmerRenderLayer.getLinesThroughWalls(3.0);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        RenderUtil.setup3D();
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        buffer.method_56824(matrixStack.method_23760(), startX, startY, startZ).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(matrixStack.method_23760(), endX, endY, endZ).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        consumers.method_22993();
        RenderUtil.clean3D();
        matrixStack.method_22909();
    }

    public static void draw2DLine(class_4587 matrixStack, float startX, float startY, float endX, float endY, float z2, Color color, float width, class_332 context) {
        matrixStack.method_22903();
        class_4588 buffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_49043((double)width));
        RenderUtil.setup();
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        buffer.method_56824(matrixStack.method_23760(), startX, startY, z2).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(matrixStack.method_23760(), endX, endY, z2).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        RenderUtil.clean();
        matrixStack.method_22909();
    }

    public static void draw2DCircle(class_4587 matrixStack, float x2, float y2, float z2, float radius, Color color, class_332 context) {
        matrixStack.method_22903();
        class_4588 buffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_62278());
        RenderUtil.setup();
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        for (float h2 = 0.0f; h2 <= radius; h2 += 0.2f) {
            for (int i2 = 0; i2 <= 360; i2 += 7) {
                buffer.method_56824(matrixStack.method_23760(), (float)((double)x2 + Math.cos((double)((float)i2 / 180.0f) * Math.PI) * (double)h2), (float)((double)y2 + Math.sin((double)((float)i2 / 180.0f) * Math.PI) * (double)h2), z2).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
                if (i2 % 2 != 0) continue;
            }
        }
        RenderUtil.clean();
        matrixStack.method_22909();
    }

    public static void draw3DLineFromPlayer(class_4587 matrixStack, class_243 start, class_243 end, Color color, WorldRenderContext context) {
        RenderUtil.draw3DLineFromPlayer(matrixStack, start, end, color, 2.5f, context);
    }

    public static void draw3DLineFromPlayer(class_4587 matrixStack, class_243 start, class_243 end, Color color, float width, WorldRenderContext context) {
        class_4184 camera = RenderUtil.mc.field_1773.method_19418();
        float startX = (float)start.field_1352;
        float startY = (float)start.field_1351;
        float startZ = (float)start.field_1350;
        float endX = (float)(end.field_1352 - camera.method_19326().field_1352);
        float endY = (float)(end.field_1351 - camera.method_19326().field_1351);
        float endZ = (float)(end.field_1350 - camera.method_19326().field_1350);
        matrixStack.method_22903();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921 layer = class_1921.method_49043((double)width);
        class_4588 buffer = consumers.getBuffer(layer);
        RenderUtil.setup3D();
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        buffer.method_56824(matrixStack.method_23760(), startX, startY, startZ).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        buffer.method_56824(matrixStack.method_23760(), endX, endY, endZ).method_22915((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        consumers.method_22993();
        RenderUtil.clean3D();
        matrixStack.method_22909();
    }

    public static class_243 getInterpolationOffset(class_1297 e2, float tickDelta) {
        if (class_310.method_1551().method_1493()) {
            return class_243.field_1353;
        }
        return new class_243(e2.method_23317() - class_3532.method_16436((double)tickDelta, (double)e2.field_6038, (double)e2.method_23317()), e2.method_23318() - class_3532.method_16436((double)tickDelta, (double)e2.field_5971, (double)e2.method_23318()), e2.method_23321() - class_3532.method_16436((double)tickDelta, (double)e2.field_5989, (double)e2.method_23321()));
    }

    public static class_243 smoothen(class_1297 e2, float tickDelta) {
        return e2.method_19538().method_1020(RenderUtil.getInterpolationOffset(e2, tickDelta));
    }

    public static class_238 smoothen(class_1297 e2, class_238 b2, float tickDelta) {
        return class_238.method_30048((class_243)RenderUtil.smoothen(e2, tickDelta), (double)b2.method_17939(), (double)b2.method_17940(), (double)b2.method_17941()).method_989(0.0, (double)(e2.method_17682() / 2.0f), 0.0);
    }

    public static void setup() {
        GlStateManager._deleteTexture((int)0);
        GlStateManager._enableBlend();
    }

    public static void setup3D() {
        RenderUtil.setup();
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
    }

    public static void clean() {
        GlStateManager._disableBlend();
        GlStateManager._bindTexture((int)0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void clean3D() {
        RenderUtil.clean();
        GlStateManager._enableDepthTest();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._enableCull();
    }

    public static List<Vector4f> getBoxVerticesToScreen2D(class_238 box) {
        class_243[] boxVerticesWorld;
        ArrayList<Vector4f> screenVertices = new ArrayList<Vector4f>();
        class_310 client = class_310.method_1551();
        class_757 gameRenderer = client.field_1773;
        class_1041 window = client.method_22683();
        if (client.field_1724 == null || gameRenderer == null) {
            return screenVertices;
        }
        class_4184 camera = gameRenderer.method_19418();
        class_243 cameraPos = camera.method_19326();
        Matrix4f customModelViewMatrix = new Matrix4f();
        customModelViewMatrix.translate((float)(-cameraPos.method_10216()), (float)(-cameraPos.method_10214()), (float)(-cameraPos.method_10215()));
        customModelViewMatrix.rotateX((float)Math.toRadians(camera.method_19329()));
        customModelViewMatrix.rotateY((float)Math.toRadians(camera.method_19330() + 180.0f));
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4f mvpMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        mvpMatrix.mul((Matrix4fc)customModelViewMatrix);
        for (class_243 worldPos : boxVerticesWorld = new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1324), new class_243(box.field_1323, box.field_1325, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1324)}) {
            Vector4f tempVec4f = new Vector4f((float)worldPos.field_1352, (float)worldPos.field_1351, (float)worldPos.field_1350, 1.0f);
            mvpMatrix.transform(tempVec4f);
            boolean isValidAndOnScreen = true;
            if (tempVec4f.w < 0.001f) {
                isValidAndOnScreen = false;
            } else {
                tempVec4f.x /= tempVec4f.w;
                tempVec4f.y /= tempVec4f.w;
                tempVec4f.z /= tempVec4f.w;
                if (tempVec4f.z < -1.0f || tempVec4f.z > 1.0f) {
                    isValidAndOnScreen = false;
                }
            }
            double screenX = ((double)tempVec4f.x + 1.0) / 2.0 * (double)window.method_4489();
            double screenY = (1.0 - (double)tempVec4f.y) / 2.0 * (double)window.method_4506();
            float finalZ = (tempVec4f.z + 1.0f) / 2.0f;
            float finalW = isValidAndOnScreen ? 1.0f : 0.0f;
            screenVertices.add(new Vector4f((float)screenX, (float)screenY, finalZ, finalW));
        }
        return screenVertices;
    }
}

