package dev.greencat.shimmer.util.render.animation;

import dev.greencat.shimmer.util.render.animation.AnimationManager;
import dev.greencat.shimmer.util.render.animation.InverseProportionFunction;
import dev.greencat.shimmer.util.render.animation.LinearFunction;

public class AnimationEngine {

   public double xCoord;
   public double yCoord;
   public double targetX;
   public double targetY;
   public boolean isRunning = false;
   public int type;
   public long endTime = 0L;
   public long startTime = 0L;
   public LinearFunction xLinearFunction;
   public LinearFunction yLinearFunction;
   public InverseProportionFunction xInverseProportionFunction;
   public InverseProportionFunction yInverseProportionFunction;
   public static final int EASE_OUT = 1;
   public static final int EASE_IN = 2;
   public static final int LINEAR = 3;


   public AnimationEngine(int x, int y) {
      this.xCoord = (double)x;
      this.yCoord = (double)y;
      this.targetX = (double)x;
      this.targetY = (double)y;
   }

   public AnimationEngine() {
      this.xCoord = 0.0D;
      this.yCoord = 0.0D;
      this.targetX = 0.0D;
      this.targetY = 0.0D;
   }

   public void setPosition(int x, int y) {
      this.xCoord = (double)x;
      this.yCoord = (double)y;
      this.targetX = (double)x;
      this.targetY = (double)y;
   }

   public void register() {
      AnimationManager.add(this);
      this.isRunning = true;
   }

   public void moveTo(float x, float y, double second, int type) {
      if(this.targetX != (double)x || this.targetY != (double)y) {
         this.startTime = System.currentTimeMillis();
         this.endTime = (long)((double)System.currentTimeMillis() + 1000.0D * second);
         this.targetX = (double)x;
         this.targetY = (double)y;
         this.xLinearFunction = null;
         this.yLinearFunction = null;
         this.xInverseProportionFunction = null;
         this.yInverseProportionFunction = null;
         this.type = type;
         if(type == 3) {
            this.xLinearFunction = new LinearFunction(1.0D, this.xCoord, 100.0D, this.targetX);
            this.yLinearFunction = new LinearFunction(1.0D, this.yCoord, 100.0D, this.targetY);
         }

         double XFunctionYPositionAt1;
         double XFunctionYPositionAt100;
         double YFunctionYPositionAt1;
         double YFunctionYPositionAt100;
         if(type == 1) {
            this.xInverseProportionFunction = new InverseProportionFunction(2500.0D);
            this.xInverseProportionFunction.setOffsetX(20.0D);
            this.yInverseProportionFunction = new InverseProportionFunction(2500.0D);
            this.yInverseProportionFunction.setOffsetX(20.0D);
            XFunctionYPositionAt1 = this.xInverseProportionFunction.getY(1.0D);
            XFunctionYPositionAt100 = this.xInverseProportionFunction.getY(100.0D);
            this.xLinearFunction = new LinearFunction(XFunctionYPositionAt1, this.xCoord, XFunctionYPositionAt100, this.targetX);
            YFunctionYPositionAt1 = this.yInverseProportionFunction.getY(1.0D);
            YFunctionYPositionAt100 = this.yInverseProportionFunction.getY(100.0D);
            this.yLinearFunction = new LinearFunction(YFunctionYPositionAt1, this.yCoord, YFunctionYPositionAt100, this.targetY);
         }

         if(type == 2) {
            this.xInverseProportionFunction = new InverseProportionFunction(-2500.0D);
            this.xInverseProportionFunction.setOffsetX(-121.0D);
            this.yInverseProportionFunction = new InverseProportionFunction(-2500.0D);
            this.yInverseProportionFunction.setOffsetX(-121.0D);
            XFunctionYPositionAt1 = this.xInverseProportionFunction.getY(1.0D);
            XFunctionYPositionAt100 = this.xInverseProportionFunction.getY(100.0D);
            this.xLinearFunction = new LinearFunction(XFunctionYPositionAt1, this.xCoord, XFunctionYPositionAt100, this.targetX);
            YFunctionYPositionAt1 = this.yInverseProportionFunction.getY(1.0D);
            YFunctionYPositionAt100 = this.yInverseProportionFunction.getY(100.0D);
            this.yLinearFunction = new LinearFunction(YFunctionYPositionAt1, this.yCoord, YFunctionYPositionAt100, this.targetY);
         }

         this.register();
      }
   }

   public void RenderTick() {
      if(System.currentTimeMillis() > this.endTime) {
         this.destroy();
         this.xCoord = this.targetX;
         this.yCoord = this.targetY;
      }

      if(this.xCoord != this.targetX) {
         this.xCoord = this.getXPosition();
      }

      if(this.yCoord != this.targetY) {
         this.yCoord = this.getYPosition();
      }

      if(this.getXPosition() > this.xCoord && this.xCoord > this.targetX) {
         this.xCoord = this.targetX;
      }

      if(this.getYPosition() > this.yCoord && this.yCoord > this.targetY) {
         this.yCoord = this.targetY;
      }

      if(this.getXPosition() < this.xCoord && this.xCoord < this.targetX) {
         this.xCoord = this.targetX;
      }

      if(this.getYPosition() < this.yCoord && this.yCoord < this.targetY) {
         this.yCoord = this.targetY;
      }

      if(this.xCoord == this.targetX && this.yCoord == this.targetY) {
         this.destroy();
      }

      this.callback();
   }

   public void callback() {
   }

   public void destroy() {
      AnimationManager.destroy(this);
      this.isRunning = false;
   }

   public double getXPosition() {
      long currentTime = System.currentTimeMillis() - this.startTime;
      long allTime = this.endTime - this.startTime;
      double progress = (double)currentTime / (double)allTime * 100.0D;
      double numberInInverseProportion;
      if(this.type == 3) {
         numberInInverseProportion = this.xLinearFunction.getY(progress);
         return numberInInverseProportion;
      } else if(progress == 0.0D) {
         return this.xCoord;
      } else if(progress >= 100.0D) {
         return this.targetX;
      } else {
         numberInInverseProportion = this.xInverseProportionFunction.getY(progress);
         double exactlyPosition = this.xLinearFunction.getY(numberInInverseProportion);
         return exactlyPosition;
      }
   }

   public double getYPosition() {
      long currentTime = System.currentTimeMillis() - this.startTime;
      long allTime = this.endTime - this.startTime;
      double progress = (double)currentTime / (double)allTime * 100.0D;
      double numberInInverseProportion;
      if(this.type == 3) {
         numberInInverseProportion = this.yLinearFunction.getY(progress);
         return numberInInverseProportion;
      } else if(progress == 0.0D) {
         return this.yCoord;
      } else if(progress >= 100.0D) {
         return this.targetY;
      } else {
         numberInInverseProportion = this.yInverseProportionFunction.getY(progress);
         double exactlyPosition = this.yLinearFunction.getY(numberInInverseProportion);
         return exactlyPosition;
      }
   }
}
