package dev.greencat.shimmer.util.render;

import dev.greencat.shimmer.util.render.ShimmerRenderPipelines;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.OptionalDouble;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_9851;
import net.minecraft.class_1921.class_4687;
import net.minecraft.class_1921.class_4688;
import net.minecraft.class_4668.class_4677;
import net.minecraft.class_4668.class_4683;

public class ShimmerRenderLayer {

   private static final Double2ObjectMap LINES_LAYERS;
   private static final Double2ObjectMap LINES_THROUGH_WALLS_LAYERS;
   private static final Object2ObjectMap TEXTURE_LAYERS;
   private static final Object2ObjectMap TEXTURE_THROUGH_WALLS_LAYERS;
   public static final class_4687 FILLED;
   public static final class_4687 FILLED_THROUGH_WALLS;
   private static final DoubleFunction LINES;
   private static final DoubleFunction LINES_THROUGH_WALLS;
   public static final class_4687 QUADS;
   public static final class_4687 QUADS_THROUGH_WALLS;
   private static final Function TEXTURE;
   private static final Function TEXTURE_THROUGH_WALLS;
   public static final class_4687 CYLINDER;


   public static class_4687 getLines(double lineWidth) {
      return (class_4687)LINES_LAYERS.computeIfAbsent(lineWidth, LINES);
   }

   public static class_4687 getLinesThroughWalls(double lineWidth) {
      return (class_4687)LINES_THROUGH_WALLS_LAYERS.computeIfAbsent(lineWidth, LINES_THROUGH_WALLS);
   }

   public static class_4687 getTexture(class_2960 texture) {
      return (class_4687)TEXTURE_LAYERS.computeIfAbsent(texture, TEXTURE);
   }

   public static class_4687 getTextureThroughWalls(class_2960 texture) {
      return (class_4687)TEXTURE_THROUGH_WALLS_LAYERS.computeIfAbsent(texture, TEXTURE_THROUGH_WALLS);
   }

   // $FF: synthetic method
   private static class_4687 lambda$static$3(class_2960 texture) {
      return class_1921.method_24049("texture_through_walls", 1536, false, true, ShimmerRenderPipelines.TEXTURE_THROUGH_WALLS, class_4688.method_23598().method_34577(new class_4683(texture, class_9851.field_52395, false)).method_23607(class_4668.field_22241).method_23617(false));
   }

   // $FF: synthetic method
   private static class_4687 lambda$static$2(class_2960 texture) {
      return class_1921.method_24049("texture", 1536, false, true, ShimmerRenderPipelines.TEXTURE, class_4688.method_23598().method_34577(new class_4683(texture, class_9851.field_52395, false)).method_23607(class_4668.field_22241).method_23617(false));
   }

   // $FF: synthetic method
   private static class_4687 lambda$static$1(double lineWidth) {
      return class_1921.method_24049("lines_through_walls", 1536, false, false, ShimmerRenderPipelines.LINES_THROUGH_WALLS, class_4688.method_23598().method_23609(new class_4677(OptionalDouble.of(lineWidth))).method_23607(class_4668.field_22241).method_23617(false));
   }

   // $FF: synthetic method
   private static class_4687 lambda$static$0(double lineWidth) {
      return class_1921.method_24049("lines", 1536, false, false, class_10799.field_56833, class_4688.method_23598().method_23609(new class_4677(OptionalDouble.of(lineWidth))).method_23607(class_4668.field_22241).method_23617(false));
   }

   static {
      // $FF: Couldn't be decompiled
   }
}
