package dev.greencat.shimmer.util.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.greencat.shimmer.mixin.DrawContextAccessor;
import dev.greencat.shimmer.util.render.ShimmerRenderLayer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_9974;
import net.minecraft.class_1921.class_4687;
import net.minecraft.class_4597.class_4598;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class RenderUtil {

   public static final class_310 mc = class_310.method_1551();


   public static void draw3DBox(class_238 boxO, Color color, class_4587 stack, WorldRenderContext context) {
      class_238 box = new class_238(boxO.field_1323, boxO.field_1322, boxO.field_1321, boxO.field_1320, boxO.field_1325, boxO.field_1324);
      class_4184 camera = mc.field_1773.method_19418();
      stack.method_22903();
      stack.method_22904(-camera.method_19326().method_10216(), -camera.method_19326().method_10214(), -camera.method_19326().method_10215());
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, (float)color.getAlpha() / 255.0F);
      class_4598 consumers = (class_4598)context.consumers();
      class_4687 layer = ShimmerRenderLayer.getLinesThroughWalls(10.0D);
      class_4588 buffer = consumers.getBuffer(layer);
      setup3D();

      for(double i = 0.0D; i <= box.field_1320 - box.field_1323; i += 0.1D) {
         for(double j = 0.0D; j <= box.field_1325 - box.field_1322; j += 0.1D) {
            class_9974.method_62292(stack, buffer, (box.field_1323 + box.field_1320 - i) / 2.0D, (box.field_1322 + box.field_1325 - j) / 2.0D, box.field_1321, (box.field_1323 + box.field_1320 + i) / 2.0D, (box.field_1322 + box.field_1325 + j) / 2.0D, box.field_1324, (float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, (float)color.getAlpha() / 255.0F);
         }
      }

      consumers.method_22993();
      clean3D();
      stack.method_22909();
   }

   public static void draw3DOutline(class_238 box, Color color, class_4587 stack, WorldRenderContext context) {
      class_4184 camera = mc.field_1773.method_19418();
      stack.method_22903();
      stack.method_22904(-camera.method_19326().method_10216(), -camera.method_19326().method_10214(), -camera.method_19326().method_10215());
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, (float)color.getAlpha() / 255.0F);
      class_4598 consumers = (class_4598)context.consumers();
      class_4687 layer = ShimmerRenderLayer.getLines(8.0D);
      class_4588 buffer = consumers.getBuffer(layer);
      setup3D();
      class_9974.method_62292(stack, buffer, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, (float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, (float)color.getAlpha() / 255.0F);
      consumers.method_22993();
      clean3D();
      stack.method_22909();
   }

   public static void draw2DOutline(class_238 box, Color color, class_4587 stack, WorldRenderContext context) {
      class_4184 c = mc.field_1773.method_19418();
      class_243 camPos = c.method_19326();
      class_243 start = box.method_1005().method_1020(camPos);
      float x = (float)start.field_1352;
      float y = (float)start.field_1351;
      float z = (float)start.field_1350;
      double r = Math.toRadians((double)(-c.method_19330() + 90.0F));
      double length = Math.sqrt((box.field_1320 - box.field_1323) * (box.field_1320 - box.field_1323) * (box.field_1324 - box.field_1321) * (box.field_1324 - box.field_1321)) / 1.5D;
      float sin = (float)(Math.sin(r) * length);
      float cos = (float)(Math.cos(r) * length);
      stack.method_22903();
      class_4598 consumers = (class_4598)context.consumers();
      class_1921 layer = class_1921.method_49043(8.0D);
      class_4588 buffer = consumers.getBuffer(layer);
      GL11.glDepthFunc(519);
      GlStateManager._enableBlend();
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y, z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y, z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, (float)((double)y + (box.field_1325 - box.field_1322)), z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y + (float)((double)y + (box.field_1325 - box.field_1322)), z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y + (float)((double)y + (box.field_1325 - box.field_1322)), z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y + (float)((double)y + (box.field_1325 - box.field_1322)), z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      consumers.method_22993();
      GL11.glDepthFunc(515);
      GlStateManager._disableBlend();
      stack.method_22909();
      RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
   }

   public static void draw2DOutline(class_1297 entity, Color color, class_4587 stack, WorldRenderContext context) {
      class_4184 c = mc.field_1773.method_19418();
      class_243 camPos = c.method_19326();
      class_243 start = entity.method_19538().method_1020(camPos);
      float x = (float)start.field_1352;
      float y = (float)start.field_1351;
      float z = (float)start.field_1350;
      double r = Math.toRadians((double)(-c.method_19330() + 90.0F));
      float sin = (float)(Math.sin(r) * ((double)entity.method_17681() / 1.5D));
      float cos = (float)(Math.cos(r) * ((double)entity.method_17681() / 1.5D));
      stack.method_22903();
      class_4598 consumers = (class_4598)context.consumers();
      class_1921 layer = class_1921.method_49043(8.0D);
      class_4588 buffer = consumers.getBuffer(layer);
      GL11.glDepthFunc(519);
      GlStateManager._enableBlend();
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y, z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y, z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y + entity.method_17682(), z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y + entity.method_17682(), z - cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y + entity.method_17682(), z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y + entity.method_17682(), z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      consumers.method_22993();
      GL11.glDepthFunc(515);
      GlStateManager._disableBlend();
      stack.method_22909();
      RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
   }

   public static void draw2DOutlinePlayer(class_1297 entity, Color color, class_4587 stack, WorldRenderContext context) {
      class_4184 c = mc.field_1773.method_19418();
      class_243 camPos = c.method_19326();
      class_243 start = entity.method_19538().method_1020(camPos);
      float x = (float)start.field_1352;
      float y = (float)start.field_1351;
      float z = (float)start.field_1350;
      double r = Math.toRadians((double)(-c.method_19330() + 90.0F));
      float sin = (float)(Math.sin(r) * ((double)entity.method_17681() / 1.5D));
      float cos = (float)(Math.cos(r) * ((double)entity.method_17681() / 1.5D));
      stack.method_22903();
      class_2960 texture = class_2960.method_60654("shimmer:player_box.png");
      class_4598 consumers = (class_4598)context.consumers();
      class_1921 layer = class_1921.method_62276(texture);
      class_4588 buffer = consumers.getBuffer(layer);
      GL11.glDepthFunc(519);
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      GlStateManager._enableBlend();
      buffer.method_56824(stack.method_23760(), x + sin, y, z + cos).method_22913(0.0F, 0.0F).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y, z - cos).method_22913(0.0F, 1.0F).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x - sin, y + entity.method_17682(), z - cos).method_22913(1.0F, 1.0F).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(stack.method_23760(), x + sin, y + entity.method_17682(), z + cos).method_22913(1.0F, 0.0F).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      consumers.method_22993();
      GL11.glDepthFunc(515);
      GlStateManager._disableBlend();
      stack.method_22909();
      RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
   }

   public static void draw3DLine(class_4587 matrixStack, class_243 start, class_243 end, Color color, WorldRenderContext context) {
      class_4184 camera = mc.field_1773.method_19418();
      float startX = (float)(start.field_1352 - camera.method_19326().field_1352);
      float startY = (float)(start.field_1351 - camera.method_19326().field_1351);
      float startZ = (float)(start.field_1350 - camera.method_19326().field_1350);
      float endX = (float)(end.field_1352 - camera.method_19326().field_1352);
      float endY = (float)(end.field_1351 - camera.method_19326().field_1351);
      float endZ = (float)(end.field_1350 - camera.method_19326().field_1350);
      matrixStack.method_22903();
      class_4598 consumers = (class_4598)context.consumers();
      class_4687 layer = ShimmerRenderLayer.getLinesThroughWalls(3.0D);
      class_4588 buffer = consumers.getBuffer(layer);
      setup3D();
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(matrixStack.method_23760(), startX, startY, startZ).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(matrixStack.method_23760(), endX, endY, endZ).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      consumers.method_22993();
      clean3D();
      matrixStack.method_22909();
   }

   public static void draw2DLine(class_4587 matrixStack, float startX, float startY, float endX, float endY, float z, Color color, float width, class_332 context) {
      matrixStack.method_22903();
      class_4588 buffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_49043((double)width));
      setup();
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(matrixStack.method_23760(), startX, startY, z).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(matrixStack.method_23760(), endX, endY, z).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      clean();
      matrixStack.method_22909();
   }

   public static void draw2DCircle(class_4587 matrixStack, float x, float y, float z, float radius, Color color, class_332 context) {
      matrixStack.method_22903();
      class_4588 buffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_62278());
      setup();
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);

      for(float h = 0.0F; h <= radius; h += 0.2F) {
         for(int i = 0; i <= 360; i += 7) {
            buffer.method_56824(matrixStack.method_23760(), (float)((double)x + Math.cos((double)((float)i / 180.0F) * 3.141592653589793D) * (double)h), (float)((double)y + Math.sin((double)((float)i / 180.0F) * 3.141592653589793D) * (double)h), z).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
            if(i % 2 == 0) {
               ;
            }
         }
      }

      clean();
      matrixStack.method_22909();
   }

   public static void draw3DLineFromPlayer(class_4587 matrixStack, class_243 start, class_243 end, Color color, WorldRenderContext context) {
      draw3DLineFromPlayer(matrixStack, start, end, color, 2.5F, context);
   }

   public static void draw3DLineFromPlayer(class_4587 matrixStack, class_243 start, class_243 end, Color color, float width, WorldRenderContext context) {
      class_4184 camera = mc.field_1773.method_19418();
      float startX = (float)start.field_1352;
      float startY = (float)start.field_1351;
      float startZ = (float)start.field_1350;
      float endX = (float)(end.field_1352 - camera.method_19326().field_1352);
      float endY = (float)(end.field_1351 - camera.method_19326().field_1351);
      float endZ = (float)(end.field_1350 - camera.method_19326().field_1350);
      matrixStack.method_22903();
      class_4598 consumers = (class_4598)context.consumers();
      class_1921 layer = class_1921.method_49043((double)width);
      class_4588 buffer = consumers.getBuffer(layer);
      setup3D();
      RenderSystem.setShaderColor((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(matrixStack.method_23760(), startX, startY, startZ).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      buffer.method_56824(matrixStack.method_23760(), endX, endY, endZ).method_22915((float)color.getRed() / 255.0F, (float)color.getGreen() / 255.0F, (float)color.getBlue() / 255.0F, 1.0F);
      consumers.method_22993();
      clean3D();
      matrixStack.method_22909();
   }

   public static class_243 getInterpolationOffset(class_1297 e, float tickDelta) {
      return class_310.method_1551().method_1493()?class_243.field_1353:new class_243(e.method_23317() - class_3532.method_16436((double)tickDelta, e.field_6038, e.method_23317()), e.method_23318() - class_3532.method_16436((double)tickDelta, e.field_5971, e.method_23318()), e.method_23321() - class_3532.method_16436((double)tickDelta, e.field_5989, e.method_23321()));
   }

   public static class_243 smoothen(class_1297 e, float tickDelta) {
      return e.method_19538().method_1020(getInterpolationOffset(e, tickDelta));
   }

   public static class_238 smoothen(class_1297 e, class_238 b, float tickDelta) {
      return class_238.method_30048(smoothen(e, tickDelta), b.method_17939(), b.method_17940(), b.method_17941()).method_989(0.0D, (double)(e.method_17682() / 2.0F), 0.0D);
   }

   public static void setup() {
      GlStateManager._deleteTexture(0);
      GlStateManager._enableBlend();
   }

   public static void setup3D() {
      setup();
      GlStateManager._disableDepthTest();
      GlStateManager._depthMask(false);
      GlStateManager._disableCull();
   }

   public static void clean() {
      GlStateManager._disableBlend();
      GlStateManager._bindTexture(0);
      RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
   }

   public static void clean3D() {
      clean();
      GlStateManager._enableDepthTest();
      GlStateManager._depthMask(true);
      GlStateManager._enableCull();
   }

   public static List getBoxVerticesToScreen2D(class_238 box) {
      ArrayList screenVertices = new ArrayList();
      class_310 client = class_310.method_1551();
      class_757 gameRenderer = client.field_1773;
      class_1041 window = client.method_22683();
      if(client.field_1724 != null && gameRenderer != null) {
         class_4184 camera = gameRenderer.method_19418();
         class_243 cameraPos = camera.method_19326();
         Matrix4f customModelViewMatrix = new Matrix4f();
         customModelViewMatrix.translate((float)(-cameraPos.method_10216()), (float)(-cameraPos.method_10214()), (float)(-cameraPos.method_10215()));
         customModelViewMatrix.rotateX((float)Math.toRadians((double)camera.method_19329()));
         customModelViewMatrix.rotateY((float)Math.toRadians((double)(camera.method_19330() + 180.0F)));
         Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
         Matrix4f mvpMatrix = new Matrix4f(projectionMatrix);
         mvpMatrix.mul(customModelViewMatrix);
         class_243[] boxVerticesWorld = new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1324), new class_243(box.field_1323, box.field_1325, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1324)};
         class_243[] var11 = boxVerticesWorld;
         int var12 = boxVerticesWorld.length;

         for(int var13 = 0; var13 < var12; ++var13) {
            class_243 worldPos = var11[var13];
            Vector4f tempVec4f = new Vector4f((float)worldPos.field_1352, (float)worldPos.field_1351, (float)worldPos.field_1350, 1.0F);
            mvpMatrix.transform(tempVec4f);
            boolean isValidAndOnScreen = true;
            if(tempVec4f.w < 0.001F) {
               isValidAndOnScreen = false;
            } else {
               tempVec4f.x /= tempVec4f.w;
               tempVec4f.y /= tempVec4f.w;
               tempVec4f.z /= tempVec4f.w;
               if(tempVec4f.z < -1.0F || tempVec4f.z > 1.0F) {
                  isValidAndOnScreen = false;
               }
            }

            double screenX = ((double)tempVec4f.x + 1.0D) / 2.0D * (double)window.method_4489();
            double screenY = (1.0D - (double)tempVec4f.y) / 2.0D * (double)window.method_4506();
            float finalZ = (tempVec4f.z + 1.0F) / 2.0F;
            float finalW = isValidAndOnScreen?1.0F:0.0F;
            screenVertices.add(new Vector4f((float)screenX, (float)screenY, finalZ, finalW));
         }

         return screenVertices;
      } else {
         return screenVertices;
      }
   }

}
