package dev.greencat.shimmer.util.player.rotation;

import dev.greencat.shimmer.util.player.rotation.Rotation;
import dev.greencat.shimmer.util.player.rotation.ServerRotation;
import net.minecraft.class_310;

public class SmoothRotation {

   private static float pitchDifference;
   public static float yawDifference;
   private static int ticks = -1;
   private static int tickCounter = 0;
   private static boolean lastTickChangeYaw = false;
   private static Runnable callback = null;
   public static boolean isServerRotation = false;
   public static boolean running = false;


   public static void smoothLook(Rotation rotation, int ms, Runnable callback) {
      smoothLook(rotation, ms, callback, false);
   }

   public static void smoothLook(Rotation rotation, int ms, Runnable callback, boolean isServerRotation) {
      if(class_310.method_1551().field_1724 != null) {
         isServerRotation = isServerRotation;
         if(isServerRotation) {
            ServerRotation.useServerRotation = true;
         }

         if(ms == 0) {
            look(rotation);
            callback.run();
            if(isServerRotation) {
               ServerRotation.useServerRotation = false;
            }

         } else {
            callback = callback;
            pitchDifference = wrapAngleTo180(rotation.getPitch() - class_310.method_1551().field_1724.method_36455());
            yawDifference = wrapAngleTo180(rotation.getYaw() - class_310.method_1551().field_1724.method_36454());
            float second = (float)ms / 1000.0F;
            ticks = (int)(second * 20.0F);
            tickCounter = 0;
         }
      }
   }

   public static void look(Rotation rotation) {
      if(!isServerRotation) {
         class_310.method_1551().field_1724.method_36456(rotation.getYaw());
         class_310.method_1551().field_1724.method_36457(rotation.getPitch());
      } else {
         ServerRotation.serverYaw = rotation.getYaw();
         ServerRotation.serverPitch = rotation.getPitch();
         lastTickChangeYaw = !lastTickChangeYaw;
         class_310.method_1551().field_1724.method_36456(class_310.method_1551().field_1724.method_36454() + (lastTickChangeYaw?-0.1F:0.1F));
      }

   }

   public static void onTick(class_310 mc) {
      if(mc.field_1724 != null) {
         if(tickCounter < ticks) {
            running = true;
            if(!isServerRotation) {
               mc.field_1724.method_36457(mc.field_1724.method_36455() + pitchDifference / (float)ticks);
               mc.field_1724.method_36456(mc.field_1724.method_36454() + yawDifference / (float)ticks);
            } else {
               ServerRotation.serverYaw += pitchDifference / (float)ticks;
               ServerRotation.serverPitch += yawDifference / (float)ticks;
               lastTickChangeYaw = !lastTickChangeYaw;
               class_310.method_1551().field_1724.method_36456(class_310.method_1551().field_1724.method_36454() + (lastTickChangeYaw?-0.1F:0.1F));
            }

            ++tickCounter;
         } else if(callback != null) {
            running = false;
            if(isServerRotation) {
               ServerRotation.useServerRotation = false;
            }

            callback.run();
            callback = null;
         }

      }
   }

   private static double wrapAngleTo180(double angle) {
      return angle - Math.floor(angle / 360.0D + 0.5D) * 360.0D;
   }

   private static float wrapAngleTo180(float angle) {
      return (float)((double)angle - Math.floor((double)(angle / 360.0F) + 0.5D) * 360.0D);
   }

}
