package dev.greencat.shimmer.util.player.rotation;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.mixin.PlayerMoveC2SPacketAccessor;
import dev.greencat.shimmer.util.player.rotation.SmoothRotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_2886;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7648;
import net.minecraft.class_2828.class_2830;
import net.minecraft.class_2828.class_2831;

public class ServerRotation {

   public static boolean useServerRotation = false;
   public static float serverYaw = 0.0F;
   private static final List serverRotationModuleList = new ArrayList();
   public static float serverPitch = 0.0F;


   public static void registerServerRotationModule(String name) {
      serverRotationModuleList.add(name);
   }

   public static boolean onPacketSent(class_2596 packet) {
      check();
      if(packet instanceof class_2828) {
         Object oldPacket = (class_2828)packet;
         if(useServerRotation) {
            PlayerMoveC2SPacketAccessor oldPacket1 = (PlayerMoveC2SPacketAccessor)packet;
            if(packet instanceof class_2830) {
               oldPacket = new class_2830(oldPacket1.getX(), oldPacket1.getY(), oldPacket1.getZ(), serverYaw, serverPitch, oldPacket1.isOnGround(), oldPacket1.horizontalCollision());
            }

            if(packet instanceof class_2831) {
               oldPacket = new class_2831(serverYaw, serverPitch, oldPacket1.isOnGround(), oldPacket1.horizontalCollision());
            }

            ((class_634)Objects.requireNonNull(class_310.method_1551().method_1562())).method_48296().method_10752((class_2596)oldPacket, (class_7648)null);
            return false;
         }
      }

      if(packet instanceof class_2886) {
         class_2886 oldPacket2 = (class_2886)packet;
         if(useServerRotation) {
            ((class_634)Objects.requireNonNull(class_310.method_1551().method_1562())).method_48296().method_10752(new class_2886(oldPacket2.method_12551(), oldPacket2.method_42081(), serverYaw, serverPitch), (class_7648)null);
            return false;
         }
      }

      return true;
   }

   private static void check() {
      boolean hasServerRotationModuleEnabled = false;
      Iterator var1 = serverRotationModuleList.iterator();

      while(var1.hasNext()) {
         String modules = (String)var1.next();
         if(Shimmer.getInstance().getModuleManager().isModuleEnabled(modules)) {
            hasServerRotationModuleEnabled = true;
            break;
         }
      }

      if(SmoothRotation.running && !SmoothRotation.isServerRotation || !hasServerRotationModuleEnabled) {
         useServerRotation = false;
      }

   }

}
