package dev.greencat.shimmer.util.player.rotation;

import dev.greencat.shimmer.util.player.rotation.Rotation;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class RotationUtil {

   public static Rotation toRotation(class_243 vec3d) {
      return new Rotation((float)getYaw((class_243)vec3d), (float)getPitch(vec3d));
   }

   public static class_243 getEyesPos() {
      class_746 player = class_310.method_1551().field_1724;
      return new class_243(player.method_23317(), player.method_23318() + (double)player.method_18381(player.method_18376()), player.method_23321());
   }

   public static double getYaw(class_1297 entity) {
      return (double)(class_310.method_1551().field_1724.method_36454() + class_3532.method_15393((float)Math.toDegrees(Math.atan2(entity.method_23321() - class_310.method_1551().field_1724.method_23321(), entity.method_23317() - class_310.method_1551().field_1724.method_23317())) - 90.0F - class_310.method_1551().field_1724.method_36454()));
   }

   public static double getYaw(class_243 pos) {
      return (double)(class_310.method_1551().field_1724.method_36454() + class_3532.method_15393((float)Math.toDegrees(Math.atan2(pos.method_10215() - class_310.method_1551().field_1724.method_23321(), pos.method_10216() - class_310.method_1551().field_1724.method_23317())) - 90.0F - class_310.method_1551().field_1724.method_36454()));
   }

   public static double getPitch(class_243 pos) {
      double diffX = pos.method_10216() - class_310.method_1551().field_1724.method_23317();
      double diffY = pos.method_10214() - (class_310.method_1551().field_1724.method_23318() + (double)class_310.method_1551().field_1724.method_18381(class_310.method_1551().field_1724.method_18376()));
      double diffZ = pos.method_10215() - class_310.method_1551().field_1724.method_23321();
      double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
      return (double)(class_310.method_1551().field_1724.method_36455() + class_3532.method_15393((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - class_310.method_1551().field_1724.method_36455()));
   }

   public static double getPitch(class_1297 entity, RotationUtil.Target target) {
      double y;
      if(target == RotationUtil.Target.HEAD) {
         y = entity.method_23320();
      } else if(target == RotationUtil.Target.BODY) {
         y = entity.method_23318() + (double)(entity.method_17682() / 2.0F);
      } else {
         y = entity.method_23318();
      }

      double diffX = entity.method_23317() - class_310.method_1551().field_1724.method_23317();
      double diffY = y - (class_310.method_1551().field_1724.method_23318() + (double)class_310.method_1551().field_1724.method_18381(class_310.method_1551().field_1724.method_18376()));
      double diffZ = entity.method_23321() - class_310.method_1551().field_1724.method_23321();
      double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
      return (double)(class_310.method_1551().field_1724.method_36455() + class_3532.method_15393((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - class_310.method_1551().field_1724.method_36455()));
   }

   public static enum Target {

      HEAD,
      BODY,
      OTHER;
      // $FF: synthetic field
      private static final RotationUtil.Target[] $VALUES = $values();


      // $FF: synthetic method
      private static RotationUtil.Target[] $values() {
         return new RotationUtil.Target[]{HEAD, BODY, OTHER};
      }

   }
}
