package dev.greencat.shimmer.util.irc;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.module.modules.misc.AuctionTracker;
import dev.greencat.shimmer.util.AuctionItem;
import dev.greencat.shimmer.util.HaikuLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_310;

public class IRC extends Thread {

   public Socket socket;
   public BufferedReader reader;
   public PrintWriter writer;
   public boolean closed = false;


   public IRC() throws IOException {
      try {
         this.socket = new Socket("xg-2.frp.one", 12783);
         this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
         this.writer = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
         HaikuLogger.info("[IRC] IRC已链接,输入!disconnect断开链接,!{消息}发送消息");
      } catch (IOException var4) {
         IOException e = var4;

         try {
            this.socket.close();
            this.reader.close();
            this.writer.close();
            e.printStackTrace();
         } catch (Exception var3) {
            ;
         }
      }

   }

   public void run() {
      String message = "";
      if(this.socket != null) {
         while(true) {
            try {
               if((message = this.reader.readLine()) == null) {
                  break;
               }
            } catch (IOException var5) {
               try {
                  if(!this.closed) {
                     if(!Shimmer.getInstance().IRC.socket.isClosed()) {
                        Shimmer.getInstance().IRC.socket.shutdownInput();
                     }

                     if(!Shimmer.getInstance().IRC.socket.isClosed()) {
                        Shimmer.getInstance().IRC.socket.shutdownOutput();
                     }

                     if(!this.socket.isClosed()) {
                        this.socket.close();
                     }

                     HaikuLogger.info("[IRC] IRC已断开链接,输入!reconnect重新链接");
                     Shimmer.getInstance().IRC = null;
                  }
               } catch (Exception var4) {
                  var4.printStackTrace();
               }
               break;
            }

            this.received(message);
         }

      }
   }

   public void received(String message) {
      if(message.equals("#requestUsername")) {
         this.write(class_310.method_1551().method_1548().method_1676());
      }

      if(message.equals("#noVerify")) {
         HaikuLogger.info("[IRC] You was kicked from IRC channel because of verify too late");
      }

      if(message.equals("#CatGirl")) {
         this.write("#CatGirl");
      }

      String username;
      if(message.startsWith("#newPlayerJoin")) {
         username = message.split("\\|")[1];
         HaikuLogger.ircJoin(username);
      }

      if(message.startsWith("#playerLeave")) {
         username = message.split("\\|")[1];
         HaikuLogger.ircLeave(username);
      }

      String[] var5;
      if(message.startsWith("#playerList")) {
         var5 = message.split("\\|");
         HaikuLogger.ircChatSplitter();
         HaikuLogger.ircOnlinePlayerNumber(var5.length - 1);
         HaikuLogger.ircChatSplitter();
         StringBuilder chatMessage = new StringBuilder();

         for(int i = 0; i < var5.length; ++i) {
            if(i != 0) {
               if(i % 3 == 0) {
                  chatMessage.append(var5[i]);
                  HaikuLogger.ircSystemMessage(chatMessage.toString());
                  chatMessage = new StringBuilder();
               } else {
                  chatMessage.append(var5[i]);
               }
            }
         }

         if((var5.length - 1) % 3 != 0) {
            HaikuLogger.ircSystemMessage(chatMessage.toString());
         }

         HaikuLogger.ircChatSplitter();
      }

      if(message.startsWith("#Auction") && Shimmer.getInstance().getModuleManager().isModuleEnabled("AuctionTracker")) {
         var5 = message.split("\\|");
         AuctionItem var6 = new AuctionItem(var5[1], var5[2], Long.parseLong(var5[3]), var5[4]);
         AuctionTracker.cowList.add(var6);
      }

      if(message.startsWith("#ChatMessage")) {
         username = message.split("\\|")[1];
         String var7 = message.split("\\|")[2];
         HaikuLogger.irc(username, var7);
      }

   }

   public void write(String message) {
      this.writer.println(message);
      this.writer.flush();
   }
}
