package dev.greencat.shimmer.module.modules.misc;

import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.Module.Category;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Translator extends Module {

   public final ModeSetting language = new ModeSetting("Language", "Traget language", "Chinese", new String[]{"Chinese", "Japanese"});
   private String prevLanguage;
   private static Translator.TranslatorImpl translator = null;
   private long lastCheck = 0L;
   private long lastClear = 0L;


   public Translator() {
      super("Translator", "Translator your skyblock item name", -1, Category.MISC);
      this.addSettings(new Setting[]{this.language});
      this.prevLanguage = this.language.getMode();
      translator = new Translator.TranslatorImpl(this.getTranslateFileName(this.language.getMode()));
   }

   private String getTranslateFileName(String mode) {
      return mode.equals("Chinese")?"zh_CN":(mode.equals("Japanese")?"ja_JP":null);
   }

   @ShimmerSubscribe
   public void onTick(TickEvent event) {
      if(System.currentTimeMillis() - this.lastCheck > 10000L && !this.prevLanguage.equals(this.language.getMode())) {
         this.lastCheck = System.currentTimeMillis();
         this.prevLanguage = this.language.getMode();
         translator = new Translator.TranslatorImpl(this.getTranslateFileName(this.language.getMode()));
      }

      if(System.currentTimeMillis() - this.lastClear >= 480000L && translator != null) {
         translator.translationCache.clear();
      }

   }

   public static String translate(String str) {
      return translator == null?str:translator.translateItemName(str);
   }


   private static class TranslatorImpl {

      private final Properties reforgeTranslate;
      private final Properties itemNameTranslate;
      private final List sortedReforgeKeys;
      private final List sortedItemNameKeys;
      public final String name;
      private boolean isAvailable;
      private final HashMap translationCache;


      public TranslatorImpl(String param1) {
         // $FF: Couldn't be decompiled
      }

      public String translateItemName(String name) {
         if(name != null && this.isAvailable && !name.isEmpty()) {
            String var10001 = name;
            if(this.translationCache.containsKey(name)) {
               return (String)this.translationCache.get(name);
            } else {
               String originalNameTemp = name;
               String nameTemp = null;
               Iterator reforgeTemp = this.sortedItemNameKeys.iterator();

               while(reforgeTemp.hasNext()) {
                  Object finalString = reforgeTemp.next();
                  if(finalString instanceof String) {
                     var10001 = finalString.toString();
                     if(originalNameTemp.contains(var10001)) {
                        nameTemp = (String)finalString;
                        var10001 = finalString.toString();
                        originalNameTemp = originalNameTemp.replace(var10001, "");
                        break;
                     }
                  }
               }

               String reforgeTemp1 = null;
               Iterator finalString1 = this.sortedReforgeKeys.iterator();

               while(finalString1.hasNext()) {
                  Object originalString = finalString1.next();
                  if(originalString instanceof String) {
                     var10001 = String.valueOf(originalString);
                     if(originalNameTemp.contains(var10001)) {
                        reforgeTemp1 = (String)originalString;
                        break;
                     }
                  }
               }

               if(reforgeTemp1 != null) {
                  var10001 = nameTemp;
               }

               String originalString1 = var10001;
               String result;
               if(nameTemp != null) {
                  String var10002;
                  if(reforgeTemp1 == null) {
                     var10002 = nameTemp;
                     this.itemNameTranslate.getProperty(nameTemp);
                  } else {
                     this.reforgeTranslate.getProperty(reforgeTemp1);
                     var10002 = this.itemNameTranslate.getProperty(nameTemp);
                  }

                  String finalString2 = var10002;
                  result = name.replace(originalString1, finalString2);
               } else {
                  result = name;
               }

               this.translationCache.put(name, result);
               return result;
            }
         } else {
            return name;
         }
      }
   }
}
