package dev.greencat.shimmer.module.modules.misc;

import dev.greencat.shimmer.event.events.LivingEntityRenderPreEvent;
import dev.greencat.shimmer.event.events.RenderEvent.Post;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.Module.Category;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_1297.class_5529;

public class DamageSplash extends Module {

   public final BooleanSetting damageSplashCompact = new BooleanSetting("Damage Splash Compact", "Compact your damage number,example:1,500,000 to 1.5M", false);
   public final NumberSetting damageSplashOffset = new NumberSetting("Damage Splash Offset", "Move you damage splash randomly", 2.0D, 0.0D, 5.0D, 0.01D);
   public final NumberSetting damageSplashAnimationSpeed = new NumberSetting("Damage Splash Animation Speed", "Change the spawn speed", 0.3D, 0.0D, 2.0D, 0.01D);
   public final NumberSetting damageSplashDuration = new NumberSetting("Damage Splash Duration", "Change the duration", 3.0D, 0.0D, 10.0D, 0.01D);
   public final BooleanSetting damageSplashCombine = new BooleanSetting("Damage Splash Combine", "Combine nearly splash text", true);
   private static final Pattern pattern = Pattern.compile("[✧✯]?(\\d{1,3}(?:,\\d{3})*[⚔+✧❤♞☄✷ﬗ✯]*)");
   private static final Deque damages = new LinkedList();
   private static final List removeList = new LinkedList();
   private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
   private static final Random random = new Random();


   public DamageSplash() {
      super("DamageSplash", "Make your damage splash better", -1, Category.MISC);
      this.addSettings(new Setting[]{this.damageSplashCompact, this.damageSplashOffset, this.damageSplashAnimationSpeed, this.damageSplashDuration, this.damageSplashCombine});
   }

   @ShimmerSubscribe
   public boolean onRenderEntity(LivingEntityRenderPreEvent event) {
      Iterator entity = removeList.iterator();

      while(entity.hasNext()) {
         class_1297 customName = (class_1297)entity.next();
         if(class_310.method_1551().field_1687 != null) {
            class_310.method_1551().field_1687.method_2945(customName.method_5628(), class_5529.field_27001);
         }
      }

      removeList.clear();
      class_1309 entity1 = event.entity;
      if(entity1 instanceof class_1531 && entity1.method_16914()) {
         String customName1 = entity1.method_5797().getString();
         Matcher matcher = pattern.matcher(customName1 == null?"":customName1);
         if(matcher.matches() && customName1 != null) {
            String damage = customName1.replaceAll("[^\\d]", "");
            long damageInteger = Long.parseLong(damage);
            if(this.damageSplashCompact.isEnabled()) {
               try {
                  double info;
                  if(damageInteger >= 1000L && damageInteger < 1000000L) {
                     info = (double)damageInteger / 1000.0D;
                     damage = decimalFormat.format(info);
                  } else if(damageInteger >= 1000000L && damageInteger < 1000000000L) {
                     info = (double)damageInteger / 1000000.0D;
                     damage = decimalFormat.format(info);
                  } else if(damageInteger >= 1000000000L) {
                     info = (double)damageInteger / 1.0E9D;
                     damage = decimalFormat.format(info);
                  }
               } catch (Exception var16) {
                  ;
               }
            }

            DamageSplash.RenderInformation info1 = new DamageSplash.RenderInformation(entity1.method_23317() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0D) - this.damageSplashOffset.getValue(), entity1.method_23318() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0D) - this.damageSplashOffset.getValue(), entity1.method_23321() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0D) - this.damageSplashOffset.getValue(), damage, new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255)), damageInteger);
            boolean combined = false;
            if(this.damageSplashCombine.isEnabled()) {
               Iterator var10 = damages.iterator();

               while(var10.hasNext()) {
                  DamageSplash.RenderInformation entry = (DamageSplash.RenderInformation)var10.next();
                  if(Math.sqrt((info1.x - entry.x) * (info1.x - entry.x) + (info1.y - entry.y) * (info1.y - entry.y) + (info1.z - entry.z)) <= 1.75D + this.damageSplashOffset.getValue()) {
                     combined = true;
                     entry.startTime = (long)((double)System.currentTimeMillis() - this.damageSplashAnimationSpeed.getValue() * 1000.0D);
                     entry.damage += damageInteger;
                     String dmgStr = String.valueOf(entry.damage);
                     if(this.damageSplashCompact.isEnabled()) {
                        try {
                           double damageDouble;
                           if(entry.damage >= 1000L && entry.damage < 1000000L) {
                              damageDouble = (double)entry.damage / 1000.0D;
                              dmgStr = decimalFormat.format(damageDouble);
                           } else if(entry.damage >= 1000000L && entry.damage < 1000000000L) {
                              damageDouble = (double)entry.damage / 1000000.0D;
                              dmgStr = decimalFormat.format(damageDouble);
                           } else if(entry.damage >= 1000000000L) {
                              damageDouble = (double)entry.damage / 1.0E9D;
                              dmgStr = decimalFormat.format(damageDouble);
                           }
                        } catch (Exception var15) {
                           ;
                        }
                     }

                     entry.message = dmgStr;
                     break;
                  }
               }
            }

            if(!combined) {
               damages.add(info1);
            }

            removeList.add(entity1);
            return false;
         }
      }

      return true;
   }

   @ShimmerSubscribe
   public void onRenderWorld(Post event) {
      if(class_310.method_1551().field_1724 == null) {
         damages.clear();
      } else {
         WorldRenderContext wrc = event.wrc;
         ArrayList removeList = new ArrayList();
         Iterator var4 = damages.iterator();

         while(var4.hasNext()) {
            DamageSplash.RenderInformation info = (DamageSplash.RenderInformation)var4.next();
            class_243 pos = new class_243(info.x, info.y, info.z);
            float scaling = (float)Math.max(2.0D, Math.log(pos.method_1022(class_310.method_1551().field_1724.method_19538()) * 3.0D));
            TextRenderUtil.renderText(wrc, class_2561.method_43470(info.message).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717(info.color.getRGB()))), pos, (float)((double)(System.currentTimeMillis() - info.startTime) <= this.damageSplashAnimationSpeed.getValue() * 1000.0D?(double)(System.currentTimeMillis() - info.startTime) / (this.damageSplashAnimationSpeed.getValue() * 1000.0D) * (double)scaling:(double)scaling), true, wrc.consumers());
            if((double)(System.currentTimeMillis() - info.startTime) >= this.damageSplashDuration.getValue() * 1000.0D) {
               removeList.add(info);
            }
         }

         if(!removeList.isEmpty()) {
            damages.removeAll(removeList);
         }

      }
   }


   static class RenderInformation {

      double x;
      double y;
      double z;
      String message;
      Color color;
      long startTime;
      long damage;


      public RenderInformation(double x, double y, double z, String message, Color color, long damage) {
         this.x = x;
         this.y = y;
         this.z = z;
         this.message = message;
         this.startTime = System.currentTimeMillis();
         this.color = color;
         this.damage = damage;
      }
   }
}
