package dev.greencat.shimmer.module.modules.combat;

import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.Module.Category;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.util.entity.EntityUtil;
import dev.greencat.shimmer.util.player.PlayerUtil;
import dev.greencat.shimmer.util.player.rotation.RotationUtil;
import dev.greencat.shimmer.util.player.rotation.ServerRotation;
import dev.greencat.shimmer.util.player.rotation.RotationUtil.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1686;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_6025;

public class Killaura extends Module {

   public final NumberSetting range = new NumberSetting("Range", "Attack range", 4.0D, 0.0D, 6.0D, 0.1D);
   public final NumberSetting wallRange = new NumberSetting("Wall Range", "Attack range through wall", 2.0D, 0.0D, 6.0D, 0.1D);
   public final BooleanSetting ignoreTamed = new BooleanSetting("Ignore Tamed", "Killaura will not attack tamed mob", false);
   public final BooleanSetting onlyOnClick = new BooleanSetting("Only On Click", "Killaura will attack when you click", false);
   public final BooleanSetting onlyOnLook = new BooleanSetting("Only On Look", "Killaura will attack when you look", false);
   public final BooleanSetting invisible = new BooleanSetting("Attack Invisible", "Killaura will attack invisible mob", false);
   public final BooleanSetting checkTeam = new BooleanSetting("Team Check", "Killaura will not attack team member", true);
   public final BooleanSetting checkNPC = new BooleanSetting("NPC Check", "Killaura will not attack NPC", true);
   private final List targets = new ArrayList();
   public boolean attacking;
   private boolean lastTickChangeYaw = false;


   public Killaura() {
      super("Killaura", "Auto kill mob around you", -1, Category.COMBAT, true);
      this.addSettings(new Setting[]{this.range, this.wallRange, this.ignoreTamed, this.onlyOnClick, this.onlyOnLook, this.invisible, this.checkTeam, this.checkNPC});
   }

   @ShimmerSubscribe
   public void onTick(TickEvent event) {
      if(mc.field_1724 != null && mc.field_1687 != null && mc.field_1761 != null) {
         if(mc.field_1724.method_5805()) {
            if(!mc.field_1761.method_2923() && !mc.field_1724.method_6115()) {
               if(this.onlyOnClick.isEnabled() && !mc.field_1690.field_1886.method_1434()) {
                  ServerRotation.useServerRotation = false;
               } else {
                  class_1297 primary;
                  if(this.onlyOnLook.isEnabled()) {
                     ServerRotation.useServerRotation = false;
                     primary = mc.field_1692;
                     if(primary == null) {
                        return;
                     }

                     if(!this.entityCheck(primary)) {
                        return;
                     }

                     this.targets.clear();
                     this.targets.add(mc.field_1692);
                  } else {
                     this.targets.clear();
                     getList(this.targets, this, 1);
                  }

                  primary = this.targets.isEmpty()?null:(class_1297)this.targets.getFirst();
                  this.attacking = true;
                  if(primary != null) {
                     ServerRotation.useServerRotation = true;
                     ServerRotation.serverYaw = (float)RotationUtil.getYaw(primary);
                     ServerRotation.serverPitch = (float)RotationUtil.getPitch(primary, Target.BODY);
                     this.lastTickChangeYaw = !this.lastTickChangeYaw;
                     class_310.method_1551().field_1724.method_36456(class_310.method_1551().field_1724.method_36454() + (this.lastTickChangeYaw?-0.1F:0.1F));
                  } else {
                     ServerRotation.useServerRotation = false;
                  }

                  if(primary != null) {
                     if(this.delayCheck()) {
                        this.targets.forEach(this);
                     }

                  }
               }
            }
         }
      }
   }

   private void attack(class_1297 target) {
      if(this.targets != null && target.method_5805() && target.method_5732()) {
         mc.field_1761.method_2918(mc.field_1724, target);
         mc.field_1724.method_6104(class_1268.field_5808);
      }
   }

   private boolean entityCheck(class_1297 entity) {
      if(!entity.equals(mc.field_1724) && !entity.equals(mc.field_1719)) {
         class_1309 hitbox;
         if(entity instanceof class_1309) {
            hitbox = (class_1309)entity;
            if(hitbox.method_29504()) {
               return false;
            }
         }

         if(entity.method_5805()) {
            if(entity instanceof class_1309) {
               hitbox = (class_1309)entity;
               if(hitbox.method_5767() && !this.invisible.isEnabled()) {
                  return false;
               }
            }

            if(entity instanceof class_1657) {
               class_1657 hitbox1 = (class_1657)entity;
               if(this.checkNPC.isEnabled() && EntityUtil.isNPC(hitbox1)) {
                  return false;
               }
            }

            if(!entity.method_5732()) {
               return false;
            } else if(entity instanceof class_1674) {
               return false;
            } else if(entity instanceof class_1695) {
               return false;
            } else if(entity instanceof class_1690) {
               return false;
            } else if(entity instanceof class_1533) {
               return false;
            } else if(entity instanceof class_1686) {
               return false;
            } else if(entity instanceof class_1295) {
               return false;
            } else {
               class_238 hitbox2 = entity.method_5829();
               if(!PlayerUtil.isWithin(class_3532.method_15350(mc.field_1724.method_23317(), hitbox2.field_1323, hitbox2.field_1320), class_3532.method_15350(mc.field_1724.method_23318(), hitbox2.field_1322, hitbox2.field_1325), class_3532.method_15350(mc.field_1724.method_23321(), hitbox2.field_1321, hitbox2.field_1324), this.range.getValue())) {
                  return false;
               } else if(!PlayerUtil.canSeeEntity(entity) && !PlayerUtil.isWithin(entity, this.wallRange.getValue())) {
                  return false;
               } else {
                  if(this.ignoreTamed.isEnabled() && entity instanceof class_6025) {
                     class_6025 player = (class_6025)entity;
                     if(player.method_35057() != null && player.method_35057().method_5667() != null && player.method_35057().method_5667().equals(mc.field_1724.method_5667())) {
                        return false;
                     }
                  }

                  if(entity instanceof class_1657) {
                     class_1657 player1 = (class_1657)entity;
                     if(this.checkTeam.isEnabled() && EntityUtil.isTeamMember(mc.field_1724, player1)) {
                        return false;
                     }
                  }

                  return true;
               }
            }
         } else {
            return false;
         }
      } else {
         return false;
      }
   }

   private boolean delayCheck() {
      return mc.field_1724.method_7261(0.5F) >= 1.0F;
   }

   public static void getList(List param0, Predicate param1, int param2) {
      // $FF: Couldn't be decompiled
   }

   public void onDisable() {
      super.onDisable();
      ServerRotation.useServerRotation = false;
      this.targets.clear();
      this.attacking = false;
   }
}
