package dev.greencat.shimmer.mixin;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.module.modules.misc.Translator;
import dev.greencat.shimmer.module.modules.player.NickHider;
import net.minecraft.class_310;
import net.minecraft.class_5223;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin({class_5223.class})
public abstract class TextVisitFactoryMixin {

   @ModifyArg(
      at =          @At(
            value = "INVOKE",
            target = "Lnet/minecraft/text/TextVisitFactory;visitFormatted(Ljava/lang/String;ILnet/minecraft/text/Style;Lnet/minecraft/text/Style;Lnet/minecraft/text/CharacterVisitor;)Z",
            ordinal = 0
         ),
      method = {"visitFormatted(Ljava/lang/String;ILnet/minecraft/text/Style;Lnet/minecraft/text/CharacterVisitor;)Z"},
      index = 0
   )
   private static String adjustText(String text) {
      String finalText = text;
      if(Shimmer.getInstance().getModuleManager().isModuleEnabled("NickHider")) {
         finalText = text.replace(class_310.method_1551().method_1548().method_1676(), NickHider.nickname.getString());
      }

      if(Shimmer.getInstance().getModuleManager().isModuleEnabled("Translator")) {
         finalText = Translator.translate(finalText);
      }

      return finalText;
   }
}
