package dev.greencat.shimmer.mixin;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.AddParticleEvent;
import dev.greencat.shimmer.event.events.ParticleRenderEvent;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1921;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_4597.class_4598;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin({class_702.class})
public class ParticleManagerMixin {

   @Inject(
      method = {"addParticle(Lnet/minecraft/client/particle/Particle;)V"},
      at = {         @At("HEAD")}
   )
   public void hookAddParticle(class_703 particle, CallbackInfo ci) {
      Shimmer.getInstance().getEventBus().post(new AddParticleEvent(particle));
   }

   @Overwrite
   private static void method_65199(class_4184 camera, float tickProgress, class_4598 vertexConsumers, class_3999 sheet, Queue particles) {
      class_4588 vertexConsumer = vertexConsumers.getBuffer((class_1921)Objects.requireNonNull(sheet.comp_3341()));
      Iterator var6 = particles.iterator();

      while(var6.hasNext()) {
         class_703 particle = (class_703)var6.next();

         try {
            particle.method_3074(vertexConsumer, camera, tickProgress);
            Shimmer.getInstance().getEventBus().post(new ParticleRenderEvent(particle, vertexConsumers));
         } catch (Throwable var11) {
            class_128 crashReport = class_128.method_560(var11, "Rendering Particle");
            class_129 crashReportSection = crashReport.method_562("Particle being rendered");
            Objects.requireNonNull(particle);
            Objects.requireNonNull(particle);
            crashReportSection.method_577("Particle", particle);
            Objects.requireNonNull(sheet);
            Objects.requireNonNull(sheet);
            crashReportSection.method_577("Particle Type", sheet);
            throw new class_148(crashReport);
         }
      }

   }
}
